<?php
// fix/core/permissions.php
// DEFINICIÓN MAESTRA BASADA EN TU MENÚ REAL (21 SECCIONES)

return [
    // --- FASE 1: GESTIÓN DE CLIENTES ---
    'dashboard' => [
        'label' => 'menu_dashboard',
        'actions' => ['view' => 'perm_view']
    ],
    'assistant' => [
        'label' => 'menu_assistant', // "Un Día Productivo"
        'actions' => ['view' => 'perm_view']
    ],
    'agenda' => [
        'label' => 'menu_agenda', // "Calendario De Citas"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'clients' => [
        'label' => 'menu_clients', // "Centro De Clientes"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'invoices' => [
        'label' => 'menu_invoices', // "Panel De Facturación"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'projects' => [
        'label' => 'menu_projects', // "Gestión De Proyectos"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'recurring' => [
        'label' => 'menu_recurring', // "Clientes Recurrentes"
        'actions' => ['view' => 'perm_view', 'manage' => 'perm_manage']
    ],
    'routes' => [
        'label' => 'menu_routes', // "Rutas Estratégicas"
        'actions' => ['view' => 'perm_view', 'manage' => 'perm_manage']
    ],

    // --- FASE 2: OPERACIÓN DEL NEGOCIO ---
    'services' => [
        'label' => 'menu_services', // "Catálogo De Servicios"
        'actions' => ['view' => 'perm_view', 'manage' => 'perm_manage']
    ],
    'finances' => [
        'label' => 'menu_finances', // "Centro Financiero"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete', 'export' => 'perm_export']
    ],
    'staff' => [
        'label' => 'menu_staff', // "Gestión De Empleados"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'complaints' => [
        'label' => 'menu_complaints', // "Control De Reclamos"
        'actions' => ['view' => 'perm_view', 'resolve' => 'perm_resolve']
    ],
    'performance' => [
        'label' => 'menu_performance', // "Rendimiento Empresarial"
        'actions' => ['view' => 'perm_view']
    ],

    // --- FASE 3: PROSPECTOS Y VENTAS ---
    'leads' => [
        'label' => 'menu_leads', // "Centro De Prospectos"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete', 'assign' => 'perm_assign']
    ],
    'lead_funnel' => [
        'label' => 'menu_lead_funnel', // "Seguimiento De Prospectos"
        'actions' => ['view' => 'perm_view', 'manage' => 'perm_manage']
    ],
    'quotes' => [
        'label' => 'menu_quotes', // "Panel De Cotizaciones"
        'actions' => ['view' => 'perm_view', 'create' => 'perm_create', 'edit' => 'perm_edit', 'delete' => 'perm_delete']
    ],
    'quotes_funnel' => [
        'label' => 'menu_quotes_funnel', // "Seguimiento De Cotización"
        'actions' => ['view' => 'perm_view']
    ],
    'discarded_leads' => [
        'label' => 'menu_discarded_leads', // "Prospectos Descartados"
        'actions' => ['view' => 'perm_view', 'restore' => 'perm_restore']
    ],

    // --- HERRAMIENTAS Y RECURSOS ---
    'business_config' => [
        'label' => 'menu_business_info', // "Información Del Negocio"
        'actions' => ['view' => 'perm_view', 'edit' => 'perm_edit']
    ],
    'account' => [
        'label' => 'menu_account', // "Administra Tu Membresía"
        'actions' => ['view' => 'perm_view', 'manage' => 'perm_manage']
    ],
    'academy' => [
        'label' => 'menu_academy', // "Video Tutoriales"
        'actions' => ['view' => 'perm_view']
    ]
];
?>