<?php
// Incluimos la conexión a la base de datos desde la misma carpeta 'admin'
require_once 'db_admin-connection.php'; 

// Indicamos que la respuesta será en formato JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Asegúrate de que la variable global $pdo esté disponible
global $pdo; 

try {
    // Seleccionamos la notificación más reciente con estado 'active'
    // Order by created_at DESC para obtener la más reciente, LIMIT 1 para solo una.
    $stmt = $pdo->prepare("SELECT title, description, internal_url, external_url FROM notifications WHERE status = 'active' ORDER BY created_at DESC LIMIT 1");
    $stmt->execute();
    
    $notification = $stmt->fetch(PDO::FETCH_ASSOC); // Obtenemos una sola fila

    // Si no hay notificaciones activas, devolvemos un objeto vacío o nulo
    if (!$notification) {
        echo json_encode(null); 
    } else {
        echo json_encode($notification);
    }

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Error en admin_notifications.php (PDO): " . $e->getMessage());
    echo json_encode(['error' => 'Error de conexión o consulta de base de datos']);
} catch (Exception $e) {
    http_response_code(500);
    error_log("Error inesperado en admin_notifications.php: " . $e->getMessage());
    echo json_encode(['error' => 'Error inesperado en el servidor']);
}
?>