<?php
// /IAMarketing/api-db/ia-business-diagnostic-radar-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['puntuacion']) || !isset($data['diagnostico_general']) || !isset($data['plan_de_accion']) || !isset($data['situations'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Faltan datos del diagnóstico.']);
    exit;
}

// CRÍTICO: Se reemplaza el ID hardcodeado por el ID del negocio de la sesión.
$business_id = $_SESSION['business_info_id'] ?? die(json_encode(['success' => false, 'message' => 'ID de Negocio no disponible en sesión.']));
$puntuacion = $data['puntuacion'];
$diagnostico = $data['diagnostico_general'];
// Codificamos los arrays a JSON
$plan_json = json_encode($data['plan_de_accion']);
$situations_json = json_encode($data['situations']); // Nuevo campo Situations

try {
    // 1. Verificar si ya existe un registro
    $check_sql = "SELECT id FROM ia_business_diagnostic_radar_results WHERE business_info_id = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$business_id]);
    
    if ($check_stmt->fetch(PDO::FETCH_ASSOC)) {
        http_response_code(409); // Conflict
        echo json_encode(['success' => false, 'message' => 'Ya existe un Radar de Diagnóstico. Use la función de actualizar.']);
        exit;
    }
    
    // 2. Insertar el nuevo registro con el campo 'situations'
    $sql = "INSERT INTO ia_business_diagnostic_radar_results (business_info_id, puntuacion, diagnostico_general, plan_de_accion, situations) VALUES (?, ?, ?, ?, ?)";
    // Transacciones ACID para la operación de inserción (aunque es una sola, es buena práctica)
    $pdo->beginTransaction();
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id, $puntuacion, $diagnostico, $plan_json, $situations_json]);
    $pdo->commit();
    
    echo json_encode(['success' => true, 'message' => 'Radar de Diagnóstico creado exitosamente.']);
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el Radar: ' . $e->getMessage()]);
}
?>