<?php
// /IAMarketing/api-db/ia-business-diagnostic-radar-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['puntuacion']) || !isset($data['diagnostico_general']) || !isset($data['plan_de_accion']) || !isset($data['situations'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Faltan datos del diagnóstico.']);
    exit;
}

// CRÍTICO: Se reemplaza el ID hardcodeado por el ID del negocio de la sesión.
$business_id = $_SESSION['business_info_id'] ?? die(json_encode(['success' => false, 'message' => 'ID de Negocio no disponible en sesión.']));
$puntuacion = $data['puntuacion'];
$diagnostico = $data['diagnostico_general'];
// Codificamos los arrays a JSON
$plan_json = json_encode($data['plan_de_accion']);
$situations_json = json_encode($data['situations']); // Nuevo campo Situations

try {
    // Actualizar el registro existente, incluyendo el nuevo campo 'situations'
    $sql = "UPDATE ia_business_diagnostic_radar_results SET puntuacion = ?, diagnostico_general = ?, plan_de_accion = ?, situations = ? WHERE business_info_id = ?";
    
    $pdo->beginTransaction();
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$puntuacion, $diagnostico, $plan_json, $situations_json, $business_id]);
    $pdo->commit();
    
    echo json_encode(['success' => true, 'message' => 'Radar de Diagnóstico actualizado exitosamente.']);
    
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el Radar: ' . $e->getMessage()]);
}
?>