<?php
// /IAMarketing/api-db/ia-ideal-client-generator-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Asumiendo business_info_id = 1

// Validar que todos los campos necesarios de la IA están presentes
$required_keys = ['titulo_perfil', 'problema', 'deseo', 'frase_marketing', 'sugerencias', 'resumen_copiar'];
foreach ($required_keys as $key) {
    if (!isset($data[$key])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => "Faltan datos del perfil (clave: $key)."]);
        exit;
    }
}

try {
    // --- LÓGICA DE LÍMITE (LA VARIACIÓN CLAVE) ---
    // 1. Contar cuántos perfiles existen para este business_id
    $check_sql = "SELECT COUNT(*) FROM ia_ideal_client_generator_results WHERE business_info_id = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$business_id]);
    $profile_count = (int)$check_stmt->fetchColumn();

    // 2. Si el conteo es 3 o más, rechazar la creación
    if ($profile_count >= 3) {
        http_response_code(409); // 409 Conflict (o 403 Forbidden)
        echo json_encode(['success' => false, 'message' => 'Límite de 3 perfiles alcanzado. Debes eliminar uno para poder crear otro.']);
        exit;
    }
    // --- FIN DE LA LÓGICA DE LÍMITE ---

    // 3. Si el límite no se ha alcanzado, proceder con la inserción
    $sql = "INSERT INTO ia_ideal_client_generator_results 
                (business_info_id, titulo_perfil, problema, deseo, frase_marketing, sugerencias, resumen_copiar) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $pdo->prepare($sql);
    
    // Codificar el array de sugerencias a JSON
    $sugerencias_json = json_encode($data['sugerencias']);
    
    $stmt->execute([
        $business_id,
        $data['titulo_perfil'],
        $data['problema'],
        $data['deseo'],
        $data['frase_marketing'],
        $sugerencias_json,
        $data['resumen_copiar']
    ]);
    
    $new_id = $pdo->lastInsertId();
    
    echo json_encode([
        'success' => true, 
        'message' => 'Perfil de Cliente Ideal creado exitosamente.',
        'new_profile_id' => $new_id // Devolvemos el ID para que el frontend lo pueda usar
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el Perfil: ' . $e->getMessage()]);
}
?>