<?php
// /IAMarketing/api-db/ia-marketing-goal-planner-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

try {
    $business_id = 1; // Asumiendo business_info_id = 1
    
    $sql = "DELETE FROM ia_marketing_goal_planner_results WHERE business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Plan de Marketing eliminado exitosamente.']);
    } else {
        echo json_encode(['success' => true, 'message' => 'No se encontró ningún Plan para eliminar.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar el Plan: ' . $e->getMessage()]);
}
?>