<?php
// /IAMarketing/api-db/ia-post-title-generator-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['id']) || !isset($data['title_type']) || !isset($data['title_es'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Required title ID, type, or content not received.']);
    exit;
}

$title_id = $data['id'];
$business_id = 1;

try {
    // Mapear el tipo de título a las columnas reales de la DB
    $column_map = [
        'problema' => ['titulo_problema_es', 'titulo_problema_en'],
        'solucion' => ['titulo_solucion_es', 'titulo_solucion_en'],
        'servicio' => ['titulo_servicio_es', 'titulo_servicio_en']
    ];

    $type = strtolower($data['title_type']);
    if (!isset($column_map[$type])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid title type specified.']);
        exit;
    }

    $col_es = $column_map[$type][0];
    $col_en = $column_map[$type][1];

    $sql = "UPDATE ia_post_title_generator_results SET 
        {$col_es} = ?, {$col_en} = ?
        WHERE id = ? AND business_info_id = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $data['title_es'],
        $data['title_en'] ?? NULL,
        $title_id,
        $business_id
    ]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Título individual actualizado con éxito.']);
    } else {
        echo json_encode(['success' => true, 'message' => 'Título actualizado (no cambios o registro no encontrado).']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while updating Title Record: ' . $e->getMessage()]);
}
?>