<?php
// /IAMarketing/api-db/project-proposals-fetch.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexin a la base de datos.']);
    exit;
}

$business_id = 1; // Asumiendo business_info_id = 1

try {
    // 1. Obtener todas las propuestas para este business_id
    $sql = "SELECT id, proposal_name, proposal_spanish, proposal_english, created_at, updated_at 
            FROM ia_project_proposals_results 
            WHERE business_info_id = ?
            ORDER BY created_at DESC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    $proposals = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'data' => $proposals]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al obtener las propuestas: ' . $e->getMessage()]);
}
?>