<?php
// /IAMarketing/api-db/ia-services-descriptions-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['id'])) {
    $desc_id = $data['id'];
    $business_id = 1; // Assuming business_info_id = 1

    try {
        // Delete the row based on ID and ensure it belongs to the current business
        $sql = "DELETE FROM ia_services_descriptions_results WHERE id = ? AND business_info_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$desc_id, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Descripción de servicio eliminada con éxito.']);
        } else {
            http_response_code(404);
            echo json_encode(['success' => false, 'message' => 'No se encontró la descripción para eliminar.']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error while deleting description: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Description ID not received for deletion.']);
}
?>