<?php
// /IAMarketing/api-db/ia-social-post-creator-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Post ID not received.']);
    exit;
}

$post_id = $data['id'];
$business_id = 1;

try {
    // USANDO NOMBRE DE TABLA CORRECTO: ia_social_post_creator_results
    $sql = "DELETE FROM ia_social_post_creator_results WHERE id = ? AND business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$post_id, $business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Publicacin individual eliminada con xito.']);
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Publicacin no encontrada o no autorizada para eliminacin.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while deleting post: ' . $e->getMessage()]);
}
?>