<?php
// /IAMarketing/api-db/ia-swot-analysis-update.php
ob_start();
// Incluye el archivo de conexión a la base de datos (que define $pdo)
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['swot_content'])) {
    $business_id = 1; // Asumiendo business_info_id = 1 (hardcoded por ahora)
    $swot_content = $data['swot_content'];
    
    try {
        // Actualizar el campo 'swot_content' en la tabla 'ia_swot_analysis_results'
        $sql = "UPDATE ia_swot_analysis_results SET swot_content = ? WHERE business_info_id = ?";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$swot_content, $business_id]);
        
        // rowCount() puede devolver 0 si los datos son idénticos, pero aun así es exitoso.
        // Se asume que si no hay error, la actualización fue exitosa.
        echo json_encode(['success' => true, 'message' => 'Análisis FODA actualizado exitosamente.']);
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el FODA: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Contenido del Análisis FODA no recibido.']);
}
?>