<?php
// /IAMarketing/api-db/ia-value-propositions-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

try {
    $business_id = 1;
    // Delete the entire row from the dedicated table
    $sql = "DELETE FROM ia_value_propositions WHERE business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    echo json_encode(['success' => true, 'message' => 'Value proposition deleted successfully.']);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while deleting VP: ' . $e->getMessage()]);
}
?>