<?php
// /IAMarketing/api/api-ideal-client-generator.php
ob_start();
require_once __DIR__ . '/../config.php';
ob_clean();

header('Content-Type: application/json');

try {
    // 1. VERIFICACIÓN DE SEGURIDAD Y DATOS
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['error' => 'Método no permitido. Solo se aceptan solicitudes POST.']);
        exit;
    }

    if (!defined('GEMINI_API_KEY') || empty(GEMINI_API_KEY)) {
        http_response_code(500);
        echo json_encode(['error' => 'La clave de API de Gemini no está configurada en el servidor. Verifica tu archivo config.php.']);
        exit;
    }
    
    $apiKey = GEMINI_API_KEY;
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE || !isset($data['service']) || !isset($data['client_desc'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Faltan los campos "service" o "client_desc" en la solicitud. ' . json_last_error_msg()]);
        exit;
    }

// 2. PROMPT MAESTRO (CON CONTEXTO Y FILOSOFÍA)
$prompt = "Actúa como un **experto en marketing con conocimientos profundos de Psicología del Consumidor y PNL (Programación Neuro Lingüística)**. Tu especialidad es **desvelar el núcleo emocional** y las motivaciones subconscientes del cliente ideal para negocios locales.

--- CÓMO PENSAMOS ---
Vamos **más allá de los datos básicos**. Para entender a un cliente, nos enfocamos en **su mundo interior**:
1.  **Su Problema Real (Lo que le Duele de Verdad):** ¿Qué situación le causa **estrés, le frustra o le quita tiempo** en su vida diaria? No es algo pequeño, es una **molestia importante y que le preocupa**. **La redacción debe ser una descripción directa del dolor del cliente en tercera persona, sin frases introductorias como 'El cliente tiene...' o 'El cliente se enfrenta a...'.**
2.  **Lo que Anhela (El Sentimiento que Busca):** ¿Qué **emoción fundamental** quiere sentir? No es solo el servicio, es el **cambio en cómo se siente**: **estar tranquilo, sentirse orgulloso, tener seguridad, disfrutar de libertad, sentirse valorado, aliviar una carga, o encontrar paz**. **La redacción debe ser una descripción directa del deseo del cliente en tercera persona, sin frases introductorias como 'El cliente anhela...' o 'El cliente desea...'.**
3.  **La Conexión Directa:** La mejor manera de hablarle a un cliente es **unir tu servicio directamente con la solución a su problema y con el sentimiento que busca**.

--- TU TAREA ---
Un dueño de negocio ha dado esta información:
- **Su Servicio:** {$data['service']}
- **Cómo son sus clientes:** {$data['client_desc']}
- **Propuesta De Valor:** {$data['value_proposition']}

**Analiza con atención** esta información. Basándote en cómo 'pensamos' (los puntos anteriores), crea un **'Perfil de Cliente Ideal' completo y útil**. Debes **identificar claramente el problema principal y el deseo emocional** que se esconden en la descripción. Después, genera **dos ideas de mensajes cortos y directos** que conecten de inmediato con ese problema y deseo, para llamar su atención.

--- REGLAS IMPORTANTES (QUÉ NO HACER) ---
- **NO uses listas con viñetas** para describir el problema, deseo o frase de marketing. Usa párrafos cohesivos.
- **NO repitas información** que ya fue mencionada. Cada sección debe aportar un valor único.
- **NO seas genérico o superficial.** Evita frases vagas. Sé directo, emocional y específico.
- **NO uses pronombres ambiguos.** Siempre deja claro a quién te refieres (al cliente, no al negocio).
- **MANTÉN UNA VOZ CONSISTENTE:** Todo el perfil, especialmente las secciones de 'Problema' y 'Deseo', debe ser redactado desde la perspectiva de un estratega de marketing que analiza al cliente, **NO como si el cliente estuviera hablando en primera persona.**
- **EVITA INTRODUCCIONES REDUNDANTES:** No uses frases como 'El cliente se enfrenta a...', 'El cliente anhela...', o 'El cliente busca...' al inicio de las secciones de 'Problema' o 'Deseo'. Ve directo a la descripción.

La respuesta debe ser un **objeto JSON válido** y todo el contenido debe estar **en español**.";

    // 3. LLAMADA A LA API CON ESQUEMA FORZADO (Y MODELO CENTRALIZADO)
    $apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/' . GEMINI_MODEL . ':generateContent?key=' . $apiKey;

    $payload = [
        'contents' => [['parts' => [['text' => $prompt]]]],
        'generationConfig' => [
            'response_mime_type' => 'application/json',
            // Esto FUERZA a la IA a responder con la estructura exacta que necesitamos.
            'response_schema' => [
                'type' => 'OBJECT',
                'properties' => [
                    'titulo_perfil' => ['type' => 'STRING', 'description' => 'Un nombre creativo y descriptivo para este arquetipo de cliente. Ej: "El Profesional Ocupado" o "La Familia que Valora su Tiempo".'],
                    'problema' => ['type' => 'STRING', 'description' => 'Un párrafo detallado describiendo el dolor o problema urgente del cliente en sus propias palabras.'],
                    'deseo' => ['type' => 'STRING', 'description' => 'Un párrafo detallado describiendo el deseo profundo o el estado emocional que el cliente anhela.'],
                    'frase_marketing' => ['type' => 'STRING', 'description' => 'Una frase de marketing potente y memorable que conecte el servicio con el deseo del cliente.'],
                    'sugerencias' => [
                        'type' => 'ARRAY',
                        'description' => 'Un array con EXACTAMENTE 3 sugerencias de marketing prácticas y específicas para anuncios, usando negritas (**palabra**) para resaltar conceptos clave.',
                        'items' => ['type' => 'STRING']
                    ],
                    'resumen_copiar' => ['type' => 'STRING', 'description' => "Un texto final formateado para copiar y pegar, usando saltos de línea '\\n' y las etiquetas 'Perfil:', 'Problema:', 'Deseo:', y 'Frase Clave:'."]
                ],
                'required' => ['titulo_perfil', 'problema', 'deseo', 'frase_marketing', 'sugerencias', 'resumen_copiar']
            ]
        ]
    ];

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_TIMEOUT => 90
    ]);

    $response_ai = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch); // Capturar errores de cURL
    curl_close($ch);

    // 4. PROCESAMIENTO Y ENVÍO DE LA RESPUESTA (CON DEPURACIÓN)
    if ($response_ai === false || $http_code !== 200) {
        http_response_code(502); // Bad Gateway
        echo json_encode([
            'error' => 'No se pudo obtener una respuesta válida del servicio de IA.',
            'curl_error' => $curl_error,
            'api_http_code' => $http_code,
            'api_response_body' => json_decode($response_ai)
        ]);
        exit;
    }

    $result_array = json_decode($response_ai, true);
    $response_text = $result_array['candidates'][0]['content']['parts'][0]['text'] ?? null;

    if ($response_text === null) {
        http_response_code(500);
        echo json_encode(['error' => 'La respuesta de la IA no contenía el formato esperado (partes de texto).', 'raw_response' => $response_ai]);
        exit;
    }

    $response_data = json_decode($response_text, true);

    if ($response_data === null) {
        http_response_code(500);
        echo json_encode(['error' => 'La IA devolvió una respuesta con formato JSON inválido.', 'raw_ai_text' => $response_text, 'json_last_error' => json_last_error_msg()]);
        exit;
    }

    // Asegurarse de que todas las claves requeridas por el schema están presentes
    $required_keys = ['titulo_perfil', 'problema', 'deseo', 'frase_marketing', 'sugerencias', 'resumen_copiar'];
    foreach ($required_keys as $key) {
        if (!isset($response_data[$key])) {
            http_response_code(500);
            echo json_encode(['error' => "La IA no devolvió la clave esperada: '$key'.", 'partial_data' => $response_data]);
            exit;
        }
    }

    // Si todo es correcto, enviar la respuesta validada.
    ob_end_clean();
    echo json_encode($response_data);
    exit;

} catch (Exception $e) {
    // Capturar cualquier excepción inesperada y devolver un JSON de error.
    http_response_code(500);
    echo json_encode(['error' => 'Error interno del servidor: ' . $e->getMessage()]);
    exit;
} finally {
    // Asegurarse de que el búfer de salida se detenga y limpie al final.
    if (ob_get_level() > 0) {
        ob_end_flush();
    }
}
?>