<?php
// db-business_config.php
global $pdo;

function cleanPhoneNumber($phone) {
    return preg_replace('/[^0-9]/', '', $phone ?? '');
}

$business_data = [];

if (isset($pdo)) {
    $stmt = $pdo->prepare("SELECT 
        company_name AS business_name, full_name AS owner_name, license_number,
        site_email AS email_primary, phone_primary, phone_secondary, whatsapp,
        logo_url AS logo_filename, website_url, timezone
    FROM business_info LIMIT 1");
    
    if ($stmt) {
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if($result) {
            $business_data = $result;
        }
    }
}

$base_url = rtrim($business_data['website_url'] ?? '', '/');
$logo_path = $business_data['logo_filename'] ?? 'img/BusinessLogo.webp';

$full_logo_url = $base_url . '/' . ltrim($logo_path, '/');

define('LOGO_FILENAME', $full_logo_url); 
define('WEBSITE_URL', $base_url);

define('BUSINESS_NAME', $business_data['business_name'] ?? 'FlowClean Services');
define('BUSINESS_OWNER', $business_data['owner_name'] ?? ''); 
define('BUSINESS_LICENSE_NUMBER', $business_data['license_number'] ?? ''); 
define('BUSINESS_TIMEZONE', $business_data['timezone'] ?? 'America/Los_Angeles'); 
define('EMAIL_PRIMARY', $business_data['email_primary'] ?? '');
define('PHONE_PRIMARY', $business_data['phone_primary'] ?? ''); 
define('PHONE_SECONDARY', $business_data['phone_secondary'] ?? '');
define('WHATSAPP_NUMBER', $business_data['whatsapp'] ?? '');
define('PHONE_PRIMARY_CLICK', '1' . cleanPhoneNumber($business_data['phone_primary'] ?? ''));
define('PHONE_SECONDARY_CLICK', '1' . cleanPhoneNumber($business_data['phone_secondary'] ?? ''));
define('WHATSAPP_NUMBER_CLICK', '1' . cleanPhoneNumber($business_data['whatsapp'] ?? ''));
define('RENEWAL_DATE', '2025-12-31');
define('OROZDESIGN_REVIEW_LINK', 'https://g.page/r/CWd9sGMLzvLCEAE/review'); 
?>