<?php
ob_start();
$response = ['success' => false, 'message' => 'DATOS INVALIDOS'];

try {
    require_once __DIR__ . '/../core/api.php';
    global $pdo;

    $data = json_decode(file_get_contents('php://input'), true);

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($data['id'])) {
        try {
            $sql = "DELETE FROM complaint_updates WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([':id' => $data['id']]);
            
            if ($stmt->rowCount() > 0) {
                $response['success'] = true;
                $response['message'] = 'NOTA BORRADA';
            } else {
                $response['message'] = 'NO SE ENCONTRO LA NOTA';
            }

        } catch (PDOException $e) {
            error_log("Error PDO en complaints-delete-update.php: " . $e->getMessage());
            $response['message'] = 'ERROR DE BASE DE DATOS';
        }
    }

} catch (Exception $e) {
    error_log("Error crítico en complaints-delete-update.php: " . $e->getMessage());
    $response['message'] = 'ERROR CRITICO';
}

if (ob_get_level() > 0) {
    ob_end_clean(); 
}

header('Content-Type: application/json');
echo json_encode($response);
exit;