<?php
ob_start();
$response = ['success' => false, 'data' => []];

try {
    require_once __DIR__ . '/../core/api.php';
    global $pdo;

    if (isset($_GET['id'])) {
        try {
            $sql = "SELECT id, message, type, created_at FROM complaint_updates WHERE complaint_id = :id ORDER BY created_at ASC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([':id' => $_GET['id']]);
            $history = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            $response['success'] = true;
            $response['data'] = $history;
            
        } catch (PDOException $e) {
            error_log("Error PDO en complaints-get-history.php: " . $e->getMessage());
            $response['message'] = 'ERROR DE BASE DE DATOS';
        }
    } else {
        $response['message'] = 'ID REQUERIDO';
    }

} catch (Exception $e) {
    error_log("Error crítico en complaints-get-history.php: " . $e->getMessage());
    $response['message'] = 'ERROR CRITICO';
}

if (ob_get_level() > 0) {
    ob_end_clean(); 
}

header('Content-Type: application/json');
echo json_encode($response);
exit;