<?php

require_once __DIR__ . '/../core/api.php';

function deleteFileFromServer($file_url, $tenant_id) {
    if (empty($file_url)) {
        return true; 
    }

    $base_upload_dir = realpath(__DIR__ . '/../uploads/'); 
    
    if (strpos($file_url, 'files/uploads/') === 0) {
        $relative_path_from_uploads = substr($file_url, strlen('../uploads/'));
    } else {
        error_log("ADVERTENCIA DE SEGURIDAD: URL de archivo inesperada para eliminar: " . $file_url);
        return false;
    }

    $file_path_on_server = $base_upload_dir . DIRECTORY_SEPARATOR . $relative_path_from_uploads;
    
    $file_path_on_server = realpath($file_path_on_server);

    $tenant_specific_upload_base = realpath($base_upload_dir . DIRECTORY_SEPARATOR . $tenant_id . DIRECTORY_SEPARATOR);

    if ($file_path_on_server === false || strpos($file_path_on_server, $tenant_specific_upload_base) !== 0) {
        error_log("ADVERTENCIA DE SEGURIDAD: Intento de eliminar archivo fuera del directorio permitido para tenant ID " . $tenant_id . ": " . $file_url);
        return false; 
    }

    if (file_exists($file_path_on_server) && is_file($file_path_on_server)) {
        if (unlink($file_path_on_server)) {
            error_log("Archivo antiguo eliminado con éxito para tenant " . $tenant_id . ": " . $file_path_on_server);
            return true;
        } else {
            error_log("ERROR: No se pudo eliminar el archivo antiguo para tenant " . $tenant_id . ": " . $file_path_on_server . ". Permisos insuficientes?");
            return false;
        }
    } else {
        error_log("ADVERTENCIA: Archivo no encontrado para eliminar: " . $file_path_on_server . " (Puede que ya estuviera eliminado o la URL fuera incorrecta).");
        return true; 
    }
}