<?php
// db/review-links-update.php
ob_start();
header('Content-Type: application/json');
require_once '../core/api.php';

try {
    $biz_id = 1;
    $platforms = ['google', 'yelp', 'facebook'];

    $pdo->beginTransaction();

    foreach ($platforms as $plat) {
        $url = $_POST['link_' . $plat] ?? '';
        
        $check = $pdo->prepare("SELECT id FROM review_links WHERE business_info_id=? AND platform_name=?");
        $check->execute([$biz_id, $plat]);
        $row = $check->fetch();

        if ($row) {
            $upd = $pdo->prepare("UPDATE review_links SET link_url=? WHERE id=?");
            $upd->execute([$url, $row['id']]);
        } else {
            if (!empty($url)) {
                $ins = $pdo->prepare("INSERT INTO review_links (business_info_id, platform_name, link_url) VALUES (?, ?, ?)");
                $ins->execute([$biz_id, $plat, $url]);
            }
        }
    }
    
    $pdo->commit();
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
ob_end_clean();
?>