<?php 
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    error_reporting(E_ALL);

    $data = json_decode(file_get_contents('php://input'), true);

    if (!$data || !isset($data['id'])) {
        throw new Exception('ID REQUERIDO');
    }

    $id = filter_var($data['id'], FILTER_VALIDATE_INT);
    if ($id === false) {
        throw new Exception('ID INVALIDO');
    }

    // --- VALIDACIÓN DE DEPENDENCIAS CRÍTICA ---
    $stmtCheck = $pdo->prepare("SELECT COUNT(*) FROM projects WHERE service_id = ? AND status != 'Archivado'");
    $stmtCheck->execute([$id]);
    $activeProjects = $stmtCheck->fetchColumn();

    if ($activeProjects > 0) {
        throw new Exception("NO SE PUEDE ELIMINAR: HAY $activeProjects PROYECTOS ACTIVOS USANDO ESTE SERVICIO.");
    }

    // Si pasa la validación, procedemos.
    $sql = "DELETE FROM services WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$id])) {
        if ($stmt->rowCount() > 0) {
            $response = ['success' => true, 'message' => 'SERVICIO ELIMINADO'];
        } else {
            throw new Exception('SERVICIO NO ENCONTRADO');
        }
    } else {
        throw new Exception('FALLO AL EJECUTAR ELIMINACION');
    }
} catch (PDOException $e) {
    error_log("PDO Error: " . $e->getMessage());
    // Mensaje genérico para el usuario, log detallado para el admin
    $response['message'] = 'ERROR DE BASE DE DATOS (POSIBLE RESTRICCIÓN)';
} catch (Exception $e) {
    $response['message'] = strtoupper($e->getMessage());
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response);
exit;
?>