<?php
ob_start();
header('Content-Type: application/json');
$response_data = ['success' => false, 'data' => null, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
    error_reporting(E_ALL);

    $user_id = 1; 

    $stmt = $pdo->prepare("
        SELECT 
            u.full_name, u.email, u.profile_photo_url, u.plan_version, 
            u.plan_renewal_date, u.next_invoice_date,
            b.state, b.timezone
        FROM users u
        LEFT JOIN business_info b ON u.user_id = b.user_id
        WHERE u.user_id = ?
    ");
    $stmt->execute([$user_id]);
    $profile = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($profile) {
        $response_data = ['success' => true, 'data' => $profile];
    } else {
        $response_data['message'] = 'PERFIL NO ENCONTRADO';
    }

} catch (PDOException $e) {
    error_log("Error PDO en user-profile-read.php: " . $e->getMessage());
    $response_data['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
     $response_data['message'] = 'ERROR CRITICO';
}

if (ob_get_level() > 0) {
    ob_end_clean();
}
echo json_encode($response_data);
exit;
?>