<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "El Ciclo De Adquisición es un mapa estratégico de 5 etapas. Describe el viaje completo que hace una persona: desde que identifica un problema o necesidad hasta que se convierte en un cliente satisfecho que valora su compra. Para <b>" . $company_name . "</b>, entender y optimizar cada fase es fundamental para construir confianza, eliminar fricciones y convertir prospectos en clientes leales, sin importar si vende productos o servicios.";
$conclusion_text = "El enfoque de <b>" . $company_name . "</b> debe ser crear una experiencia fluida y coherente en las 5 fases. No se trata solo de vender, sino de guiar. Al alinear sus estrategias de marketing, ventas y servicio con la mentalidad del cliente en cada etapa, fomenta una relación positiva que no solo genera una venta, sino que construye la base para la lealtad, las reseñas positivas y el crecimiento sostenible del negocio.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, su objetivo debe ser que la transición entre cada fase sea lo más fluida y segura posible para el cliente potencial.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, la etapa de Análisis es su mejor fuente de información para mejorar el servicio y fomentar la retención.";

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #3 El Ciclo De Adquisición <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #3 El Ciclo De Adquisición" 
      data-page-subtitle="Análisis Estratégico del Proceso de Compra" 
      data-page-icon="clipboard-check">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="acquisition-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Aprovechar el Ciclo de Adquisición</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Convertir El Interés De las personas en Ventas</h2>
            <p class="mt-2 text-white/90 max-w-xl">Aprenda a guiar al cliente en cada etapa, desde que reconoce su necesidad hasta que analiza su servicio, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Ciclo de Adquisición" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="acquisitionAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="acquisition-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="clipboard-check" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">EL CICLO DE ADQUISICIÓN</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="lightbulb" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 1: RECONOCIMIENTO</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente ideal identifica una necesidad</p>
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="md:col-span-1">
                <h3 class="font-black text-[var(--color-secondary)]">Nivel de Conciencia: BAJO</h3>
                <p class="text-gray-600 text-lg">El cliente ideal siente una frustración o identifica una necesidad (ej. 'esto es muy complicado', 'no tengo tiempo para esto', 'necesito resolverlo'), pero aún no ha buscado activamente una solución profesional.</p>
            </div>
            <div class="md:col-span-1">
                <h3 class="font-black text-[var(--color-secondary)]">Comportamiento</h3>
                <p class="text-gray-600 text-lg">Comenta su problema con conocidos o tolera la situación. Puede quejarse (ej. 'mi coche hace un ruido raro', 'mi web no atrae clientes', 'necesito un regalo') pero no pasa a la acción de contrar el servicio o adquirir el producto.</p>
            </div>
            <div class="md:col-span-1">
                <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                <p class="text-gray-600 text-lg">Crear contenido que eduque sobre el problema del cliente ideal, no sobre el negocio. Usar publicidad o marketing local para visibilizar la necesidad y los beneficios de resolverla (ej. 'recupera tu tiempo', 'mejora tu imagen').</p>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="search" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 2: BÚSQUEDA</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente ideal busca soluciones</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nivel de Conciencia: MODERADO</h3>
                    <p class="text-gray-600 text-lg">Es consciente de su necesidad y está explorando activamente quién puede ayudarle. Compara soluciones y proveedores.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Comportamiento</h3>
                    <p class="text-gray-600 text-lg">Busca en Google (ej. 'mejor servicio de limpieza en Texas', 'servicio de contabilidad'), pregunta en grupos locales o pide recomendaciones. Compara opciones basándose en reseñas, ubicación y como persive el servicio.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg">Tener una sólida presencia digital y local (Perfil de Google, redes sociales). Gestionar activamente las reseñas y publicar contenido útil que responda preguntas comunes. El posicionamiento local es fundamental.</p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="list-filter" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 3: EVALUACIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente Potencial compara opciones</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nivel de Conciencia: ALTO</h3>
                    <p class="text-gray-600 text-lg">El cliente ideal es plenamente consciente, evalúa cuál proveedor ofrece el mejor valor, calidad y confianza para su situación específica.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Comportamiento</h3>
                    <p class="text-gray-600 text-lg">Ha reducido sus opciones a 2 o 3 negocios. Analiza detalladamente, busca testimonios específicos, revisa portafolios y compara el valor percibido (no solo el precio). Busca señales de confianza.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg">Destacar la Propuesta De Valor (UVP). Usar pruebas sociales estrategicas (testimonios, reseñas, portafolios). Ofrecer garantías o consultas iniciales para reducir el riesgo percibido.</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="shopping-cart" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 4: ADQUISICIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente toma la decisión de compra</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nivel de Conciencia: MUY ALTO</h3>
                    <p class="text-gray-600 text-lg">Está seguro de su decisión y solo necesita completar el proceso de compra o contratación de la forma más sencilla posible.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Comportamiento</h3>
                    <p class="text-gray-600 text-lg">Busca un proceso de compra sin fricción. Si es complicado, lento o confuso, puede abandonar el proceso o irse con la competencia. Valora la claridad en los precios y los próximos pasos.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg">Optimizar el proceso de pago o contratación. Ofrecer múltiples formas de contacto/pago (WhatsApp, formulario simple). Ser transparente con precios y términos. Confirmar la compra inmediatamente.</p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="check-square" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 5: ANÁLISIS</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente evalúa la experiencia</p>
                </div>
            </div>
             <div class="space-y-4">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nivel de Conciencia: REFLEXIVO</h3>
                    <p class="text-gray-600 text-lg">Considera si el producto o servicio cumplió sus expectativas y si la experiencia general fue positiva. Decide si valió la pena.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Comportamiento</h3>
                    <p class="text-gray-600 text-lg">Evalúa si el resultado final resolvió su necesidad inicial. Decide si volvería a comprar o si recomendaría el negocio. Es el momento en que decide dejar una reseña (buena o mala).</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg">Solicitar activamente retroalimentación (ej. '¿Cómo le parecio el servicio?'). Pedir una reseña si la experiencia fue positiva. Ofrecer incentivos para la recompra o programas de lealtad. Analizar quejas para mejorar.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('acquisitionAudioPlayer');
        const widget = document.getElementById('acquisition-video-widget');
        const showContainer = document.getElementById('show-acquisition-video-container');
        const widgetKey = 'hide_acquisition-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="acquisition-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="acquisition-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>