<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "El Recorrido del Cliente (Customer Journey) es un mapa estratégico de 5 etapas fundamentales. Describe el camino completo desde que alguien se da cuenta de una necesidad (de su situación actual) hasta que se convierte en un embajador de su marca. Para <b>" . $company_name . "</b>, entender esto es clave para optimizar cada punto de contacto (entre el usuario y la marca) y garantizar una experiencia de venta satisfactoria.";
$conclusion_text = "Al seguir esta estructura, <b>" . $company_name . "</b> crea una experiencia coherente que alinea las emociones y acciones del cliente ideal en cada fase. Esto no solo atrae nuevos clientes, sino que los retiene a largo plazo y los convierte en promotores activos, fortaleciendo la reputación y el crecimiento del negocio.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, su trabajo es diseñar una experiencia de adquisición fluida para guiar al cliente a través de estas cinco etapas.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, una gran experiencia en la etapa de Retención es lo que crea la Promoción del mañana.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #2 El Customer Journey <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
        .color-success {
            color: var(--color-secondary);
        }
        .border-success {
            border-color: var(--color-secondary);
        }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #2 El Customer Journey" 
      data-page-subtitle="Análisis Estratégico del Recorrido del Cliente" 
      data-page-icon="route">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="journey-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Por qué Comprender el Customer Journey</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Crear una Experiencia de Venta de 5 Estrellas</h2>
            <p class="mt-2 text-white/90 max-w-xl text-lg">Aprenda a optimizar cada punto de contacto con su cliente, desde que lo descubre hasta que lo recomienda, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Customer Journey" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="journeyAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            SU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="journey-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="route" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">EL MAPA HUMANO DEL CLIENTE IDEAL</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="lightbulb" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 1: DESCUBRIMIENTO</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente nota el problema</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <p class="text-gray-600 text-lg">En esta etapa, el cliente potencial se da cuenta de que necesita ayuda (para solucionar un problema o una necesidad que tiene) por falta de tiempo o energía.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Emoción Dominante</h3>
                    <p class="text-gray-600 text-lg"><b>Frustración Y Estrés</b> por la acumulación de tareas</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Puntos de Impacto Clave</h3>
                    <ul class="list-none space-y-2 mt-1">
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Anuncios (Redes Sociales):</b> Deben enfocarse en ahorrar tiempo o dinero y reducir estrés.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Google (Local):</b> Aparecer en búsquedas locales con buenas reseñas.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Boca a Boca:</b> Incentivar a clientes actuales a recomendar el servicio a sus conocidos.</span></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="list-filter" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 2: CONSIDERACIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente compara opciones</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <p class="text-gray-600 text-lg">Ahora el cliente ideal ya ha encontrado personas o negocios que brindan la solución que busca y está comparando proveedores. Busca el servicio más <b>confiable y seguro</b>, no solamente el más barato.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Emoción Dominante</h3>
                    <p class="text-gray-600 text-lg"><b>Cautela y preocupación</b> por la seguridad y fiabilidad del negocio y del personal.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Puntos De Impacto Clave</h3>
                    <ul class="list-none space-y-2 mt-1">
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Sitio Web:</b> Debe mostrar testimonios reales, garantías de seguridad y opciones.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Reseñas (Google):</b> Son clave y fundamentales. Responder a reseñas genera confianza.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Contenido:</b> Videos o artículos que muestren cómo se soluciona el problema.</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="check-check" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i> 
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 3: DECISIÓN</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente elige y contrata</p>
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="space-y-4">
                <div>
                    <p class="text-gray-600 text-lg">El cliente toma la decisión final y ha seleccionado el negocio. Se comunica para saber más, hace preguntas específicas, pide una cotización y revisa garantías.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Emoción Dominante</h3>
                    <p class="text-gray-600 text-lg"><b>Optimismo</b> (si percibe profesionalismo) mezclado con <b>ansiedad</b> (sobre la calidad del producto o servicio).</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Puntos de Impacto Clave</h3>
                    <ul class="list-none space-y-2 mt-1">
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Cotización Clara:</b> Digital o impresa, debe ser transparente y profesional.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Comunicación Directa:</b> WhatsApp o teléfono para resolver dudas rápido.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Venta Fácil:</b> Un proceso de contratación y pago sencillo, sin fricciones.</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="calendar-check" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 4: RETENCIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente se fideliza</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <p class="text-gray-600 text-lg">El objetivo en esta etapa es garantizar una <b>calidad consistente en el producto o servicio</b>. El cliente programa citas regulares y evalúa cada visita, o vuelve a comprar.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Emoción Dominante</h3>
                    <p class="text-gray-600 text-lg"><b>Satisfacción y Alivio</b> (si la calidad es constante) o <b>Frustración</b> (si la calidad falla).</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Puntos de Impacto Clave</h3>
                    <ul class="list-none space-y-2 mt-1">
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Seguimiento:</b> Correos o mensajes post-servicio pidiendo retroalimentación.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Comunicación Abierta:</b> WhatsApp para ajustar fechas o servicios.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Fidelización:</b> Descuentos o promociones por lealtad.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Pedir Reseñas:</b> A clientes felices para reforzar la reputación en línea.</span></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="megaphone" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 5: PROMOCIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente se vuelve embajador</p>
                </div>
            </div>
             <div class="space-y-4">
                <div>
                    <p class="text-gray-600 text-lg">El cliente satisfecho recomienda el servicio a otros (familiares, amigos y conocidos). Comparte su experiencia en redes sociales, habla con amigos y deja reseñas positivas.</p>

                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Emoción Dominante</h3>
                    <p class="text-gray-600 text-lg"><b>Orgullo y Satisfacción</b> por haber encontrado un servicio confiable y de calidad.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Puntos de Impacto Clave</h3>
                    <ul class="list-none space-y-2 mt-1">
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Facilitar Compartir:</b> Crear contenido visual que el cliente pueda compartir fácilmente.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Incentivar Reseñas:</b> Animar a dejar reseñas en Google, Yelp, etc., o incluso en video.</span></li>
                        <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 color-success"></i><span class="text-gray-600 text-lg"><b>Programa De Referidos:</b> Implementar recompensas por atraer nuevos clientes.</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('journeyAudioPlayer');
        const widget = document.getElementById('journey-video-widget');
        const showContainer = document.getElementById('show-journey-video-container');
        const widgetKey = 'hide_journey-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="journey-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="journey-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>