<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
include 'db/docs-config.php';

$company_name = 'Su Negocio Local';
$owner_first_name = 'Propietario';
$config = null; 

try {
    // Mitigación de SQLi: Usar sentencia preparada
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    if ($stmt_config->execute()) {
        $config = $stmt_config->fetch(PDO::FETCH_ASSOC);
    }
} catch (PDOException $e) {
    // Registrar error sin exponer detalles al usuario
    error_log("Error al cargar config del dashboard: " . $e->getMessage());
}

if ($config) {
    $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
    $full_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
    
    $first_name_parts = explode(' ', $full_name);
    $owner_first_name = $first_name_parts[0];
}

// Variables temporales a ser reemplazadas por lógica real de progreso de documentos si existe
$classes_completed = 5; 
$total_classes = 12;
$completion_percentage = ($total_classes > 0) ? round(($classes_completed / $total_classes) * 100) : 0;
$adn_progress = ['doc_status' => []]; // Se mantiene la inicialización

if (ob_get_level() > 0) { ob_end_clean(); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Manaules De Crecimiento Empresarial <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .adn-card { background-color: white; border-radius: 0.75rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); transition: transform 0.2s; }
        .adn-card:hover { transform: translateY(-3px); }
        .locked-overlay { background: rgba(7, 22, 45, 0.85); backdrop-filter: blur(4px); }
        .progress-bar-bg { background-color: #e2e8f0; }
        .progress-bar-fill { width: <?php echo $completion_percentage; ?>%; background-color: var(--color-secondary); }
        .unlocked-icon { color: var(--color-highlight); }

        .adn-doc-image-card {
            min-height: 500px;
            overflow: hidden;
            border-radius: 0.75rem;
            position: relative;
            cursor: pointer;
            box-shadow: 0 10px 15px -3px rgba(0,0,0,0.3);
            transition: transform 0.3s ease-in-out;
        }
        .adn-doc-image-card:hover {
            transform: translateY(-5px);
        }
        .adn-doc-image-card .background-image {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            opacity: 0.7;
            transition: transform 0.4s ease-in-out;
            filter: grayscale(80%);
        }
        .adn-doc-image-card:hover .background-image {
            transform: scale(1.05);
            filter: grayscale(0%);
        }
        .adn-doc-image-card .content-overlay {
            position: relative;
            z-index: 10;
            height: 100%;
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.85) 0%, rgba(0, 0, 0, 0.5) 40%, transparent 100%);
        }
    </style>

</head>
<body data-page-title="Manaules De Crecimiento Empresarial" 
      data-page-subtitle="Tu Centro de Configuración De Negocios" 
      data-page-icon="bar-chart-2">
    
     <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'menu.php'; ?>
    
    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            
          <div class="show-widget-container hidden flex justify-end p-0" id="videotutorial-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                    data-widget-id="welcome-adn-video">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>VER VIDEO DE BIENVENIDA</span>
                </button>
           </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-10">
        
                <section class="p-6 md:p-10 video-widget" id="welcome-adn-video">
            <div class="blob bl1"></div><div class="blob bl2"></div>
            <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
                <div class="lg:col-span-1">
                    <span class="chip"><i data-lucide="award" class="w-4 h-4"></i> Manaules De Crecimiento Empresarial</span>
                    <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">¡Aquí Empieza Tu Viaje De Crecimiento Empresarial!</h2>
                    <p class="mt-2 text-white/90 max-w-xl text-lg">Estos manuales te ayudarán a convertir <b><?php echo $company_name; ?></b> en una fuente de adquisición de clientes potenciales predecible</p>
                </div>
                <div class="lg:col-span-1">
                    <div class="w-full">
                        <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                            <div class="relative w-full" style="padding-bottom: 56.25%;">
                                <video class="absolute top-0 left-0 w-full h-full object-cover" id="welcomeAdnVideoPlayer" controls controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    TU NAVEGADOR NO SOPORTA LA ETIQUETA DE VIDEO
                                </video>
                                <div id="playOverlayAdn" class="absolute inset-0 flex justify-center items-center cursor-pointer group">
                                    <img src="img/VideoLeccion-IAMarketing.jpg" alt="Video Placeholder - ADN Welcome" class="absolute inset-0 w-full h-full object-cover">
                                    <div class="absolute inset-0 w-full h-full bg-black/40 transition-colors group-hover:bg-black/60"></div>
                                    <i data-lucide="play" class="relative w-16 h-16 text-white opacity-80 group-hover:opacity-100 transition-opacity"></i>
                                </div>
                            </div>
                            <div class="p-4 text-white/90 text-sm flex items-center justify-between">
                                <span class="inline-flex items-center gap-2">
                                    <i data-lucide="play-circle" class="w-4 h-4"></i>
                                    Video De Bienvenida
                                </span>

                                <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                        data-widget-id="welcome-adn-video" 
                                        title="Ocultar el video de bienvenida">
                                    OCULTAR VIDEO
                                    <i data-lucide="square-x" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <section>
            <h2 class="text-5xl font-black uppercase text-[var(--color-primary)] mb-6 flex items-center gap-2">
                <i data-lucide="file-text" class="w-6 h-6 text-[var(--color-secondary)]"></i>
                Manuales De Crecimiento Empresarial
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                
                <?php 
                foreach ($strategic_docs as $id => $doc): 
                    $url = htmlspecialchars($doc['url']); 
                ?>
                <a href="<?php echo $url; ?>" class="adn-doc-image-card group">
                    <div class="background-image" style="background-image: url('<?php echo htmlspecialchars($doc['image_url']); ?>');"></div>
                    
                    <div class="content-overlay">
                        
                        <div class="absolute top-4 right-4 p-2 rounded-full bg-black/50">
                            <i data-lucide="file-check-2" class="w-6 h-6 unlocked-icon text-white"></i>
                        </div>

                        <span class="text-xs font-semibold text-white uppercase">Manual De Crecimiento #<?php echo $id; ?></span>
                        <h3 class="title font-black text-3xl uppercase text-white mt-1"><?php echo htmlspecialchars($doc['title']); ?></h3>
                        <h3 class="subtitle font-black text-2xl uppercase text-[var(--color-highlight)] mt-1"><?php echo htmlspecialchars($doc['subtitle']); ?></h3>
                    </div>
                </a>
                <?php endforeach; ?>
                
            </div>
        </section>

    </div>
    </main>
</div>
<script>
    const toggleWidgetVisibility = (widgetId, isHidden) => {
        const widget = document.getElementById(widgetId);
        const showContainer = document.querySelector(`#show-welcome-adn-container`);
        const videoPlayer = widget ? widget.querySelector('video') : null;

        if (!widget || !showContainer) return; 

        if (isHidden) {
            widget.classList.add('hidden');
            showContainer.classList.remove('hidden');
            if (videoPlayer) videoPlayer.pause(); 
        } else {
            widget.classList.remove('hidden');
            showContainer.classList.add('hidden');
        }
        localStorage.setItem(`hide_${widgetId}`, isHidden ? 'true' : 'false');
    };

    document.addEventListener('DOMContentLoaded', () => {
        if (typeof lucide !== 'undefined') { lucide.createIcons(); }
        
        // --- Lógica del Video de Bienvenida ---
        const videoPlayer = document.getElementById('welcomeAdnVideoPlayer');
        const playOverlay = document.getElementById('playOverlayAdn');

        if (videoPlayer && playOverlay) {
            playOverlay.addEventListener('click', () => {
                playOverlay.classList.add('hidden');
                videoPlayer.play();
            });
            
            videoPlayer.addEventListener('pause', () => {
                 if (videoPlayer.currentTime < videoPlayer.duration) {
                    playOverlay.classList.remove('hidden');
                }
            });
             videoPlayer.addEventListener('ended', () => {
                 playOverlay.classList.remove('hidden');
            });
        }
        
        // --- Lógica del Menú y Ocultar/Mostrar ---
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        if (mobileMenuButton && sidebar && sidebarOverlay) {
            mobileMenuButton.addEventListener('click', () => {
                sidebar.classList.toggle('-translate-x-full');
                sidebarOverlay.classList.toggle('hidden');
            });
            sidebarOverlay.addEventListener('click', () => {
                sidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.add('hidden');
            });
        }
        
        // Ocultar/Mostrar Buttons
        document.querySelector('.hide-widget-btn[data-widget-id="welcome-adn-video"]')?.addEventListener('click', (e) => toggleWidgetVisibility('welcome-adn-video', true));
        document.querySelector('.show-widget-btn[data-widget-id="welcome-adn-video"]')?.addEventListener('click', (e) => toggleWidgetVisibility('welcome-adn-video', false));

        // Comprobar y aplicar el estado guardado al cargar la página
        const isHidden = localStorage.getItem(`hide_welcome-adn-video`) === 'true';
        toggleWidgetVisibility(isHidden,);
    });
</script>
<script src="files/toast.js"></script>
</body>
</html>