<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "Conocer al cliente ideal es una herramienta estratégica que define cómo <b>" . $company_name . "</b> comunica, vende y se posiciona. Este documento expone el perfil psicológico y conductual del cliente al que su negocio debe aspirar para optimizar sus esfuerzos. Estos <b>datos clave</b> servirán como base para su estrategia de marketing y ventas.";
$conclusion_text = "El cliente ideal de <b>" . $company_name . "</b> no solo compra un servicio o producto; compra <b>certidumbre y alivio</b>. La clave es construir una marca que comunique <b>confianza, profesionalismo y valor</b> en cada punto de contacto, convirtiendo a su negocio en la única <b>opción lógica y segura</b> en su área. Este perfil es el camino para atraer, retener y convertir a los clientes correctos, <b>" . $owner_first_name . "</b>.";
$owner_mention_1 = "Analice este perfil para afinar su mensaje, <b>" . $owner_first_name . "</b>.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, la clave es la confianza.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #5 El Perfil De Cliente Ideal <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }

        .color-brand-success { color: var(--color-secondary); }
        .color-brand-danger { color: var(--color-primary); } 
        .bg-danger-light { background-color: var(--color-secondary, #f0f4f8); border-color: var(--color-highlight, #d1e2f0); } 
    </style>

</head>
<body data-page-title="Manual De Crecimiento #5 El Perfil De Cliente Ideal" 
      data-page-subtitle="Análisis Y Definición Del Cliente Ideal Para Su Negocio" 
      data-page-icon="target">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="icp-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Usar el Perfil de Cliente Ideal</h2> 
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Tener Una Máxima Estrategia Publicitaria</h2>
            <p class="mt-2 text-white/90 max-w-xl">Entienda la psicología detrás de las decisiones de compra de su cliente y aprenda a usar este perfil en su marketing y ventas, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - ICP Analysis" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                        
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="icpAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="icp-video-widget" title="Ocultar el video explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
            <div class="flex items-center">
                <i data-lucide="target" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
                <div>
                    <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">EL PERFIL DE CLIENTE IDEAL</h1>
                    <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
                </div>
            </div>
            <div class="mt-4 text-lg text-gray-700 text-lg pl-14 space-y-3">
                <p><?php echo $intro_description; ?></p>
                <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
            </div>
        </div>
        
            
            <div class="grid grid-cols-1 md:flex md:gap-8 items-stretch">
                
                <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                    <div class="mb-4">
                        <div class="flex items-center">
                            <i data-lucide="frown" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                            <h2 class="text-3xl font-black text-[var(--color-primary)]">EL PROBLEMA PRINCIPAL</h2>
                        </div>
                        <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Su Realidad No Deseada (Quiere Alejarse)</p>
                    </div>
                    <p class="text-gray-700 text-lg">
                        El cliente vive con la <b>incertidumbre</b> de no saber si encontrará un proveedor confiable, que cumpla lo prometido y que valore su tiempo y dinero.
                    </p>
                </div>

                <div class="flex justify-center items-center" aria-hidden="true">
                    <i data-lucide="arrow-big-down-dash" class="w-12 h-12 text-gray-400 md:hidden"></i>
                    <i data-lucide="arrow-big-right-dash" class="w-16 h-16 text-gray-400 hidden md:block"></i>
                </div>

                <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                    <div class="mb-4">
                        <div class="flex items-center">
                            <i data-lucide="laugh" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                            <h2 class="text-3xl font-black text-[var(--color-primary)]">LA TRANSFORMACIÓN</h2>
                        </div>
                        <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Su Realidad Deseada (Quiere Acercarse)</p>
                    </div>
                    <p class="text-gray-700 text-lg">
                        Que pase de la incertidumbre a una <b>experiencia de confianza y satisfacción garantizada</b>, sintiéndose un cliente valorado.
                    </p>
                </div>
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4 border-b pb-3">
                    <div class="flex items-center">
                        <i data-lucide="brain-circuit" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-3xl font-black text-[var(--color-primary)]">¿QUÉ SIENTE?</h2>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Problema Principal</h3>
                        <p class="text-gray-600 text-lg">Siente frustración por el tiempo perdido, el servicio mediocre y el miedo a ser estafado o a que no le cumplan lo prometido.</p>
                    </div>
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Preocupaciones</h3>
                        <ul class="list-none space-y-2 mt-1">
                            <li class="flex items-start"><i data-lucide="alert-triangle" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span class="text-gray-600 text-lg">Servicio no confiable (tardanzas, cancelaciones).</span></li>
                            <li class="flex items-start"><i data-lucide="alert-triangle" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span class="text-gray-600 text-lg">Resultado mediocre o incompleto.</span></li>
                            <li class="flex items-start"><i data-lucide="alert-triangle" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span class="text-gray-600 text-lg">Precios ocultos o que suben inesperadamente.</span></li>
                        </ul>
                    </div>
                     <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Desafíos</h3>
                        <p class="text-gray-600 text-lg">Filtrar entre la multitud de opciones y encontrar al <b>experto local</b> que ofrezca una verdadera garantía de calidad y transparencia. <b><?php echo $owner_mention_2; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4 border-b pb-3">
                    <div class="flex items-center">
                        <i data-lucide="heart-handshake" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-3xl font-black text-[var(--color-primary)]">¿QUÉ QUIERE?</h2>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Objetivo Principal</h3>
                        <p class="text-gray-600 text-lg">Solucionar su necesidad de forma <b>rápida y efectiva</b>, con la menor fricción posible.</p>
                    </div>
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Transformación Deseada</h3>
                        <p class="text-gray-600 text-lg">Cambiar la sensación de "tener un problema" por la de "tener una <b>solución de largo plazo</b>" y poder seguir con su día.</p>
                    </div>
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Deseo Profundo</h3>
                        <p class="text-gray-600 text-lg">Sentir que tomó la decisión correcta y que la inversión valió la pena, <b>garantizando la paz mental</b>.</p>
                    </div>
                </div>
            </div>

            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4 border-b pb-3">
                    <div class="flex items-center">
                        <i data-lucide="brain" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-3xl font-black text-[var(--color-primary)]">¿QUÉ HACE?</h2>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Intereses Principales</h3>
                        <p class="text-gray-600 text-lg">Se enfoca en <b>soluciones prácticas</b>, conveniencia y la mejor relación calidad-precio.</p>
                    </div>
                    <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Dónde Busca Soluciones</h3>
                        <p class="text-gray-600 text-lg">Búsquedas en <b>Google/Google Maps (Móvil)</b>, recomendaciones personales y redes sociales como Facebook/Nextdoor.</p>
                    </div>
                     <div>
                        <h3 class="font-black text-[var(--color-secondary)]">Canales Preferidos</h3>
                        <p class="text-gray-600 text-lg"><b>Llamada y WhatsApp</b> para inmediatez; web profesional y reseñas para verificar autoridad.</p>
                    </div>
                </div>
            </div>
        </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4">
                    <div class="flex items-center">
                        <i data-lucide="thumbs-up" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-2xl font-black text-[var(--color-primary)]">EXPECTATIVAS CLAVE</h2>
                    </div>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Que Espera de nuestro servicio</p>
                </div>
                <ul class="space-y-2 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="check" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Garantía y Confianza:</b> Debe inspirar seguridad y profesionalismo.</span></li>
                    <li class="flex items-start"><i data-lucide="check" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Transparencia:</b> Precios claros, sin cargos ocultos o sorpresas.</span></li>
                    <li class="flex items-start"><i data-lucide="check" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Rapidez:</b> Respuesta inmediata a la solicitud inicial.</span></li>
                    <li class="flex items-start"><i data-lucide="check" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Cortesía:</b> Un trato amable y respetuoso.</span></li>
                </ul>
            </div>
            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4">
                    <div class="flex items-center">
                        <i data-lucide="thumbs-down" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-2xl font-black text-[var(--color-primary)]">DOLORES (Miedos)</h2>
                    </div>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Por experiencias negativas anteriores</p>
                </div>
                <ul class="space-y-2 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="x" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-danger"></i><span><b>Perder el tiempo</b> con un servicio que no funciona.</span></li>
                    <li class="flex items-start"><i data-lucide="x" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-danger"></i><span>Que le <b>cancelen o lleguen tarde</b> sin aviso.</span></li>
                    <li class="flex items-start"><i data-lucide="x" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-danger"></i><span><b>Problemas de comunicación</b> o malentendidos.</span></li>
                    <li class="flex items-start"><i data-lucide="x" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-danger"></i><span>Sentir que pagó demasiado por un <b>servicio básico</b>.</span></li>
                </ul>
            </div>
        </div>
        
            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4">
                    <div class="flex items-center">
                        <i data-lucide="shield-alert" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-3xl font-black text-[var(--color-primary)]">OBJECIONES COMUNES EN EL MERCADO LOCAL</h2>
                    </div>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Que lo puede detener para no adquirir el servicio o producto</p>
                </div>
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4 mt-4 text-center">
                    <div class="p-3 bg-danger-light border border-gray-200 rounded-lg"><i data-lucide="wallet" class="mx-auto w-8 h-8 text-[var(--color-highlight)] mb-1"></i><span class="text-md font-bold uppercase text-white">Es demasiado caro, comparado con otros</span></div>
                    <div class="p-3 bg-danger-light border border-gray-200 rounded-lg"><i data-lucide="handshake" class="mx-auto w-8 h-8 text-[var(--color-highlight)] mb-1"></i><span class="text-md font-bold uppercase text-white">No confío en este negocio, no me da confianza</span></div>
                    <div class="p-3 bg-danger-light border border-gray-200 rounded-lg"><i data-lucide="eye-off" class="mx-auto w-8 h-8 text-[var(--color-highlight)] mb-1"></i><span class="text-md font-bold uppercase text-white">Ya tuve malas experiencias</span></div>
                    <div class="p-3 bg-danger-light border border-gray-200 rounded-lg"><i data-lucide="timer" class="mx-auto w-8 h-8 text-[var(--color-highlight)] mb-1"></i><span class="text-md font-bold uppercase text-white">Necesito una solución para ayer</span></div>
                    <div class="p-3 bg-danger-light border border-gray-200 rounded-lg"><i data-lucide="package" class="mx-auto w-8 h-8 text-[var(--color-highlight)] mb-1"></i><span class="text-md font-bold uppercase text-white">No entiendo la diferencia de servicios</span></div>
                </div>
            </div>
        
            <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
                <div class="mb-4">
                    <div class="flex items-center">
                        <i data-lucide="lightbulb" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                        <h2 class="text-3xl font-black text-[var(--color-primary)]">RECOMENDACIONES ESTRATÉGICAS</h2>
                    </div>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Acciones que debes tener en cuenta sí o sí</p>
                </div>
                <ul class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Transparencia Total:</strong> Mostrar precios iniciales o un proceso de cotización simple pero profesional.</div></li>
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Prueba Social:</strong> Las <b>reseñas</b> (Google, Facebook) deben ser el foco principal de la comunicación.</div></li>
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Garantía Clara:</strong> Ofrecer una <b>garantía de satisfacción</b> para eliminar el miedo al riesgo.</div></li>
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Velocidad de Respuesta:</strong> Contestar rápido (usando el CRM) demuestra <b>valoración por el tiempo del cliente</b>.</div></li>
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Autoridad Visual:</strong> Un <b>sitio web profesional</b>, un *branding* coherente y (si aplica) un local limpio y ordenado.</div></li>
                    <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Diferenciación de Servicios:</strong> <b>Paquetes claros</b> eliminan la incertidumbre y facilitan la decisión.</div></li>
                </ul>
            </div>

        
        <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
            <div class="flex items-center mb-4">
               <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
                <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
            </div>
            <p class="text-white/90 text-lg">
                <?php echo $conclusion_text; ?>
            </p>
            <p class="text-white/80 text-lg mt-4 text-right">¡Éxito en su estrategia, <b><?php echo $owner_first_name; ?></b>!</p>
        </div>

    </div>
    </main>
    
    <script>
    (function() {
        // --- Video & Ocultar/Mostrar Logic ---
        // Nota: Se ha cambiado a icpAudioPlayer en el HTML
        const audioPlayer = document.getElementById('icpAudioPlayer'); 
        const widget = document.getElementById('icp-video-widget');
        const showContainer = document.getElementById('show-icp-video-container');

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                // Se asegura pausar si existe y está en reproducción
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(`hide_icp-video-widget`, isHidden ? 'true' : 'false');
        };
        
        // --- Document Ready Logic ---
        document.addEventListener('DOMContentLoaded', () => {
            // Mobile Menu Logic (Copied from Dashboard)
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Ocultar/Mostrar Buttons
            document.querySelector('.hide-widget-btn[data-widget-id="icp-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="icp-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Initial State Check
            const isHidden = localStorage.getItem(`hide_icp-video-widget`) === 'true';
            toggleWidgetVisibility(isHidden);

            // Initialize Lucide Icons
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>