<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "Las tendencias del mercado son los cambios en las preferencias y necesidades de los clientes en <b>su industria</b>. Comprenderlas es clave para que <b>" . $company_name . "</b> ofrezca lo que los clientes realmente quieren, permitiéndole destacarse de la competencia.";
$conclusion_text = "El entorno de los servicios locales está cambiando rápidamente, <b>" . $owner_first_name . "</b>, impulsado por la demanda de sostenibilidad, tecnología y servicios personalizados. Adaptar las operaciones de <b>" . $company_name . "</b> a estas tendencias lo posicionará de manera competitiva para un crecimiento sostenible y exitoso.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, analice estas tendencias para identificar oportunidades y evitar quedar obsoleto.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, lo que hoy es 'emergente', mañana será 'actual' y fundamental para el negocio.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #8 Las Tendencias Del Mercado <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
        .color-trend-success { color: var(--color-secondary); } 
        .color-trend-decline { color: var(--color-primary); } 
        .border-trend-success { border-color: var(--color-secondary); }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #8 Las Tendencias Del Mercado" 
      data-page-subtitle="Análisis Estratégico del Entorno Competitivo" 
      data-page-icon="trending-up">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="trends-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Utilizar las Tendencias Actuales</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Anticiparse al Crecimiento del Negocio</h2>
            <p class="mt-2 text-white/90 max-w-xl text-lg">Aprenda a identificar lo 'actual', lo 'emergente' y lo que está 'en declive' para tomar mejores decisiones, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Tendencias del Mercado" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="trendsAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="trends-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="trending-up" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">LAS TENDENCIAS DEL MERCADO</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4">
            <i data-lucide="zap" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">TENDENCIAS ACTUALES</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Lo que los clientes potenciales demandan AHORA</p>
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-x-8 gap-y-4 text-gray-700">
            <div>
                <h3 class="font-black text-gray-800">Sostenibilidad y Conciencia</h3>
                <p class="text-lg">Los clientes ya no solo compran un producto o adquieren un servicio; <b>compran valores</b>. Quieren saber que su dinero apoya a un negocio que es socialmente responsable, utiliza prácticas justas o minimiza su impacto ambiental. La transparencia sobre sus prácticas es ahora un argumento de venta.</p>
            </div>
            <div>
                <h3 class="font-black text-gray-800">Tecnología y Eficiencia</h3>
                <p class="text-lg">Los clientes esperan una experiencia sin fricción. Quieren agendar citas en línea, recibir recordatorios automáticos (por WhatsApp o correo) y pagar digitalmente. Valoran la tecnología que les ahorra tiempo y hace que interactuar con su negocio sea fácil y conveniente.</p>
            </div>
            <div>
                <h3 class="font-black text-gray-800">La Hiper-Personalización</h3>
                <p class="text-lg">La era del paquete único para todos ha terminado. Los clientes esperan que el negocio entienda sus necesidades personales relacionadas al problema. Quieren la flexibilidad de añadir o quitar opciones y sentir que el servicio está 'hecho a medida' para ellos, no que son un número más.</p>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="sunrise" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">TENDENCIAS EMERGENTES</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Las oportunidades del FUTURO CERCANO</p>
                </div>
            </div>
            <div class="space-y-4 text-gray-700">
                <div>
                    <h3 class="font-black text-gray-800">Enfoque en el Bienestar (Holístico)</h3>
                    <p class="text-lg">Los clientes potenciales están empezando a ver cómo diferentes servicios afectan su bienestar general. Ya no se trata solo del resultado (ej. un producto entregado), sino de cómo el proceso (ej. ingredientes, ruido, estrés) impacta su salud mental y física. Los negocios que promueven un entorno saludable y de bajo estrés están ganando terreno.</p>
                </div>
                 <div>
                    <h3 class="font-black text-gray-800">Soluciones de Nicho y Asistentes de IA</h3>
                    <p class="text-lg">La inteligencia artificial está dejando de ser una fantasía. Los clientes comenzarán a interactuar con 'agentes chatbots' para preguntas 24/7. Además, valorarán a las empresas que utilizan herramientas especializadas y tecnología de punta para resolver problemas muy específicos, viéndolos como verdaderos 'expertos' en un nicho específico.</p>
                </div>
                 <div>
                    <h3 class="font-black text-gray-800">Inclusión y Accesibilidad</h3>
                    <p class="text-lg">El mercado exige que los negocios sean accesibles para todos. Esto incluye desde tener un sitio web que personas con discapacidades puedan usar, hasta ofrecer servicios que consideren diversas necesidades culturales o de estilo de vida. Ser un negocio 'para todos' se está convirtiendo en una expectativa.</p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="trending-down" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">TENDENCIAS EN DECLIVE</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Lo que los clientes están ABANDONANDO</p>
                </div>
            </div>
            <div class="space-y-4 text-gray-700">
                <div>
                    <h3 class="font-black text-gray-800">Prácticas Opacas o Agresivas</h3>
                    <p class="text-lg">Los clientes rechazan activamente a las empresas que utilizan químicos fuertes, tienen prácticas laborales dudosas o dañan el medio ambiente. La falta de transparencia es un gran 'NO'. Si un producto o método se percibe como 'tóxico' (literal o figurativamente), está perdiendo mercado.</p>
                </div>
                 <div>
                    <h3 class="font-black text-gray-800">Rigidez y Talla Única</h3>
                    <p class="text-lg">Los clientes ya no toleran el "así es como lo hacemos". Los paquetes de servicios inflexibles, la falta de opciones de personalización y las políticas rígidas de "tómalo o déjalo" están en rápido declive. Los clientes prefieren pagar un poco más por un servicio que se adapte a ellos y a sus necesidades específicas.</p>
                </div>
                <div>
                <h3 class="font-black text-gray-800">Chatbots Sin Personalización</h3>
                    <p class="text-lg">Los clientes rechazan los sistemas automatizados que solo ofrecen respuestas prehechas o menús rígidos. La automatización sin humanidad está en declive, ya que el cliente espera una interacción más contextualizada, como la que ofrecen los agentes de IA avanzados.</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="mb-4">
            <div class="flex items-center">
                <i data-lucide="check-square" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">RECOMENDACIONES ESTRATÉGICAS</h2>
            </div>
            <p class="text-sm font-bold uppercase text-[var(--color-secondary)] pl-12">Acciones para capitalizar las tendencias</p>
        </div>
        <ul class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4 text-gray-700 text-lg">
            <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Adoptar Prácticas Sostenibles:</strong> Comunicar (si aplica) el uso de productos responsables o prácticas de reducción de desechos. Mejora la reputación.</div></li>
            <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Integrar Tecnología:</strong> Implementar un sistema de reservas en línea o recordatorios por WhatsApp. La eficiencia se percibe como profesionalismo.</div></li>
            <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Ofrecer Servicios Personalizados:</strong> Desarrollar planes flexibles o complementos (*add-ons*) que permitan al cliente construir su propio servicio.</div></li>
            <li class="flex items-start"><i data-lucide="check-square" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><div><strong class="text-gray-900">Enfoque En La Confianza:</strong> Implementar protocolos de calidad claros. Usar testimonios y reseñas como prueba social para fortalecer la percepción de confianza.</div></li>
        </ul>
    </div>


    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="award" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('trendsAudioPlayer');
        const widget = document.getElementById('trends-video-widget');
        const showContainer = document.getElementById('show-trends-video-container');
        const widgetKey = 'hide_trends-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="trends-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="trends-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>