<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "Los puntos de contacto son <b>todas las interacciones y momentos</b> en los que un cliente potencial o un cliente actual entra en contacto con <b>" . $company_name . "</b>. Cada punto es crucial, ya que ayuda a guiar al cliente desde el descubrimiento hasta la lealtad. Optimizar estos puntos es clave para una experiencia satisfactoria.";
$conclusion_text = "Esta estructura permite a <b>" . $company_name . "</b> optimizar cada punto de contacto, asegurando que cada etapa se maximice para aumentar la conversión y la fidelización. Al implementar estas estrategias, su negocio no solo captará nuevos clientes, sino que los retendrá y los convertirá en promotores.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, su objetivo es que la transición entre cada fase sea lo más fluida y segura posible para el cliente.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, debe incentivar a los clientes satisfechos para convertirlos en embajadores de su marca.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #4 Puntos De Contacto <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
        .color-success {
            color: var(--color-secondary); 
        }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #4 Los Puntos De Contacto" 
      data-page-subtitle="Análisis Estratégico de las Interacciones con el Cliente" 
      data-page-icon="message-circle">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="touchpoints-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Utilizar los Puntos de Contacto</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Crear una Experiencia de Venta Coherente</h2>
            <p class="mt-2 text-white/90 max-w-xl text-lg">Aprenda a identificar y optimizar cada interacción del cliente en las 5 etapas del recorrido, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Puntos de Contacto" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="touchpointsAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="touchpoints-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="message-circle" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">LOS PUNTOS DE CONTACTO</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 text-lg pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="search" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 1: DESCUBRIMIENTO</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente potencial apenas se da cuenta de la necesidad</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Qué Ocurre en esta Fase</h3>
                <p class="text-gray-700 text-lg">El cliente potencial tiene un problema, pero no está buscando activamente una solución. Puede sentir frustración (ej. "no tengo tiempo", "esto es muy complicado") pero lo tolera. Aún no ha decidido comprar o contratar un servicio. Si está buscando una solución, su búsqueda es pasiva o se enfoca en los síntomas (ej. "cómo resolver X problema").</p>
            </div>
            
            <div class="pt-2">
                <h3 class="font-black text-[var(--color-secondary)]">Estrategia y Puntos de Contacto Clave</h3>
                <p class="text-gray-700 text-lg mb-3">En esta fase tu objetivo no es vender, sino <b>educar y hacerte visible</b>. Debes interrumpir su rutina y posicionarte como un experto confiable en el tema. Debes tener activos todos o alguno de estos activos digitales para que el cliente potencial pueda encontrarte.</p>
                <ul class="space-y-3 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Perfil De Google (GMB):</b> Destacar en búsquedas locales con un perfil optimizado, fotos y reseñas.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Página Web (SEO):</b> Optimizar el sitio para que aparezca en búsquedas locales relacionadas con los problemas que resuelves.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Artículos (Blog):</b> Crear contenido que responda a las búsquedas pasivas (ej. "cómo solucionar...") para atraer tráfico y educar.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Publicidad (Google/Facebook/Instagram Ads):</b> Usar anuncios segmentados que capten a quienes buscan soluciones o que muestren la propuesta de valor a audiencias interesadas.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Redes Sociales:</b> Publicar contenido visual atractivo (ej. "antes y después", demostraciones) para captar la atención.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Recomendación Boca A Boca:</b> Fomentar activamente las recomendaciones de clientes actuales, quizás con incentivos.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Material Publicitario:</b> Distribuir folletos o *brochures* en áreas estratégicas para reforzar la presencia local.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Directorios Locales:</b> Asegurarse de aparecer en directorios en línea (como Yelp) o impresos relevantes.</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="list-filter" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 2: CONSIDERACIÓN</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente potencial busca activamente y compara opciones</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Qué Ocurre en esta Fase</h3>
                <p class="text-gray-700 text-lg">El cliente ideal ya decidió que necesita una solución y está buscando activamente cómo resolverla. Compara proveedores, precios y reputaciones. Está cauteloso y busca señales de confianza para reducir su riesgo. Lee reseñas y compara sitios web. Se pregunta: "¿Cuál es la mejor opción para mí?"</p>
            </div>
            
            <div class="pt-2">
                <h3 class="font-black text-[var(--color-secondary)]">Estrategia y Puntos de Contacto Clave</h3>
                <p class="text-gray-700 text-lg mb-3">Tu objetivo es <b>demostrar que realmente puedes ayudarle con ese problema y generar su confianza</b>. Debes saber cómo diferenciarte de la competencia y probar que eres la opción más segura e inteligente con los siguientes activos digitales.</p>
                <ul class="space-y-3 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Página De Ventas:</b> Tener una página web clara que muestre paquetes, precios y qué incluye cada opción.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Opiniones De Clientes:</b> Mostrar reseñas positivas de Google, Yelp, etc., para reforzar la confianza.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Testimonios y Referencias:</b> Incluir testimonios en la web o redes sociales que resalten cómo has ayudado a otros.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Videos Publicitarios / Portafolio:</b> Crear videos cortos o galerías de fotos que muestren tu proceso y los resultados visuales.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Material Impreso (*Door Hangers*):</b> Distribuir material en zonas clave con detalles de servicios para reforzar el conocimiento.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Presentación De Negocio:</b> Enviar un PDF profesional que detalle la propuesta de valor (ideal para clientes B2B o servicios de alto valor).</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Campañas De *Remarketing*:</b> Recordar a los visitantes de tu web sobre tus servicios mediante anuncios en Google o redes sociales.</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="check-check" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i> 
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 3: DECISIÓN</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente ideal está listo para comprar, pero necesita un empujón</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Qué Ocurre en esta Fase</h3>
                <p class="text-gray-700 text-lg">El cliente ideal ha reducido sus opciones y ha elegido a tu negocio y quizás uno o dos competidores. Está listo para contratar o adquirir el producto, pero puede sentir ansiedad de último minuto. Teme tomar una mala decisión, que el proceso sea complicado o que haya costos ocultos. Busca facilidad y confirmación.</p>
            </div>
            
            <div class="pt-2">
                <h3 class="font-black text-[var(--color-secondary)]">Estrategia y Puntos de Contacto Clave</h3>
                <p class="text-gray-700 text-lg mb-3">Tu objetivo en esta fase es <b>eliminar toda la fricción posible</b>. Haz que el proceso de compra o contratación sea ridículamente fácil, rápido y seguro.</p>
                <ul class="space-y-3 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Chat / WhatsApp:</b> Canales de respuesta rápida para resolver dudas de último minuto y agendar fácilmente.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Llamada Telefónica:</b> Facilitar la opción de contacto directo para personalizar el servicio o aclarar preguntas complejas.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>*Email Marketing* / Mensajes SMS:</b> Enviar ofertas especiales, promociones o recordatorios para motivar la acción inmediata.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Publicidad *Remarketing* (YouTube Ads / Display Ads):</b> Mostrar anuncios con un Llamado a la Acción (CTA) claro como "Reserva hoy" a audiencias que ya te consideran.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Video De Ventas:</b> Un video corto que explique el proceso de contratación, beneficios y garantías para reducir la ansiedad.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Referencia De Cliente Actual:</b> Un cliente existente que recomienda tu servicio puede ser el empujón final de confianza que alguien necesita.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Correo Directo (Material Impreso):</b> Enviar material a hogares con promociones que hagan el proceso de contratación más accesible.</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="calendar-check" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 4: RETENCIÓN</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente potencial evalúa la experiencia post-compra</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Qué Ocurre en esta Fase</h3>
                <p class="text-gray-700 text-lg">La venta ya se hizo (has ganado un nuevo cliente). Ahora el cliente evalúa si su experiencia cumplió o superó sus expectativas. ¿El producto/servicio funcionó? ¿El resultado fue el prometido? Esta fase determina si será un cliente de una sola vez o un cliente leal de por vida.</p>
            </div>
            
            <div class="pt-2">
                <h3 class="font-black text-[var(--color-secondary)]">Estrategia y Puntos de Contacto Clave</h3>
                <p class="text-gray-700 text-lg mb-3">Tu objetivo en esta fase es <b>validar su decisión y construir una relación</b>. Demuestra que realmente te importa el resultado del cliente, no solo la venta del producto o servicio.</p>
                <ul class="space-y-3 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Seguimiento Post-Compra:</b> Una llamada o mensaje para asegurarse de que el cliente esté satisfecho y abordar inquietudes.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Correos De Seguimiento:</b> Enviar recordatorios de próximos servicios (si aplica) o recomendaciones personalizadas.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Programas De Fidelización:</b> Ofrecer recompensas, descuentos o servicios adicionales por contrataciones recurrentes.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Promociones Especiales:</b> Ofrecer descuentos exclusivos para clientes leales para incentivar la continuidad.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Solicitud De Reseñas En Línea:</b> Pedir activamente a clientes satisfechos que dejen reseñas en Google, Yelp, etc.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Solicitud De Testimonios y Referencias:</b> Usar la satisfacción del cliente para pedir testimonios y activar el programa de referidos.</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="megaphone" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">ETAPA 5: PROMOCIÓN</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">El cliente se convierte en un promotor de tu marca</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Qué Ocurre en esta Fase</h3>
                <p class="text-gray-700 text-lg">El cliente está encantado contigo y tu servicio. Superaste sus expectativas. Está tan feliz con su decisión que siente orgullo y está dispuesto a compartir su experiencia positiva con amigos, familia y en línea. Se convierte en una fuente de recomendación Boca a Boca.</p>
            </div>
            
            <div class="pt-2">
                <h3 class="font-black text-[var(--color-secondary)]">Estrategia y Puntos de Contacto Clave</h3>
                <p class="text-gray-700 text-lg text-lg mb-3">Tu objetivo es <b>facilitar e incentivar</b> a que compartan su experiencia con otras personas. Dales las herramientas adecuadas y una razón para hacerlo.</p>
                <ul class="space-y-3 text-gray-700 text-lg">
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Programa De Referidos:</b> Implementar un programa formal que recompense (con descuentos, servicios gratis, etc.) tanto al cliente existente como al nuevo.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Incentivar El Boca a Boca:</b> Fomentar activamente las recomendaciones personales, incluso fuera de un programa formal.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Solicitar Reseñas y Opiniones En Línea:</b> Facilitar al máximo que dejen reseñas en plataformas clave.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Usar Testimonios y Referencias:</b> Publicar los testimonios de clientes satisfechos en redes sociales, web y material impreso.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Encuesta Estratégica:</b> Realizar encuestas de satisfacción que pregunten "Qué tan probable es que nos recomiendes" y ofrecer incentivos por hacerlo.</span></li>
                    <li class="flex items-start"><i data-lucide="circle-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-success"></i>
                        <span><b>Campaña Que Nos Promocionen:</b> Animar a los clientes a compartir su experiencia en redes sociales (ej. etiquetando al negocio) a cambio de un premio o reconocimiento.</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="award" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i> 
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA:</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('touchpointsAudioPlayer');
        const widget = document.getElementById('touchpoints-video-widget');
        const showContainer = document.getElementById('show-touchpoints-video-container');
        const widgetKey = 'hide_touchpoints-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="touchpoints-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="touchpoints-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>