<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "La Tabla De Transformación es una herramienta clave de marketing para comunicar la propuesta de valor de <b>" . $company_name . "</b>.  Su propósito es comprender de forma visual cómo sus prospectos pasan de su situación actual (desafíos) a un estado favorable, resaltando los cambios tangibles y emocionales que su servicio provee. ";
$conclusion_text = "Esta tabla es fundamental para conectar y demostrar cómo la vida del cliente ideal puede mejorar. Al enfocarse en cambios tangibles y emocionales, <b>" . $company_name . "</b> refuerza la confianza y el deseo de tomar acción, convirtiendo el valor de su servicio en algo claro y atractivo.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, use esta tabla de transformacion para que los prospectos entiendan y <b>sientan</b> el impacto real que aporta su servicio. ";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, la transformación emocional ('Cómo Se Sentirá') es a menudo más poderosa que la tangible.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #6 La Tabla De Transformación <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
        .color-brand-action { color: var(--color-highlight); }
        .color-brand-success { color: var(--color-secondary); }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #6 La Tabla de Transformación" 
      data-page-subtitle="Análisis Estratégico del Antes y Después" 
      data-page-icon="table-properties">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="transformation-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Usar la Tabla de Transformación</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Convertir Desconocidos en Clientes</h2>
            <p class="mt-2 text-white/90 max-w-xl text-lg">Aprenda a comunicar el Antes y Después tangible y emocional de su servicio para motivar al cliente, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Tabla de Transformación" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="transformationAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="transformation-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="table-properties" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">LA TABLA DE TRANSFORMACIÓN</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="clipboard-list" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)] flex items-center gap-3 flex-wrap">
                        <span>QUÉ TIENE</span><i data-lucide="arrow-right" class="w-7 h-7"></i><span>QUÉ TENDRÁ</span>
                    </h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">El Cambio Tangible del cliente ideal</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Mostrar la transformación que el cliente ideal experimentará de forma concreta, enfocándose en los resultados prácticos del servicio.  Responde a la pregunta: "¿Qué cambiará para mí al usar este servicio?". </p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Es importante porque los clientes suelen prestar atención a problemas específicos que quieren solucionar.  Este cambio tangible les ayuda a confiar en que el servicio es efectivo. </p>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="frown" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)] flex items-center gap-3 flex-wrap">
                        <span>SE SIENTE</span><i data-lucide="arrow-right" class="w-7 h-7"></i><span>SE SENTIRÁ</span>
                    </h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">El Cambio Emocional que experimentara</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Describir cómo cambiarán las emociones del cliente ideal, pasando de sentimientos negativos, como frustración, a positivos, como tranquilidad y satisfacción. </p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Las emociones son claves en la decisión de contratar un servicio.  Mostrar este cambio conecta al cliente potencial con el valor emocional de la solución que estás ofreciendo. </p>
        </div>

    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="clock" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)] flex items-center gap-3 flex-wrap">
                        <span>Cómo Vive Su Día a Día</span>
                    </h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">La Transformación que desea a diario</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Explicar cómo el servicio hará que la rutina diaria del prospecto sea más sencilla y le permita enfocarse en lo que realmente importa.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Esto ayuda al cliente potencial a imaginar cómo su vida mejorará, conectando el servicio con una experiencia más cómoda y satisfactoria.</p>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="user-check" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)] flex items-center gap-3 flex-wrap">
                        <span>Mejora Del Estatus</span>
                    </h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">La Transformación de la Percepción</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Mostrar cómo el servicio no solo resuelve un problema, sino también mejora la imagen que el cliente potencial tiene de sí mismo o que los demás tienen de él.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Muchos clientes valoran no solo los resultados funcionales, sino también cómo los hace sentir respecto a su situación y a cómo los perciben los demás.</p>
        </div>

    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="shield-alert" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">ANTICIPACIÓN DE OBJECIONES</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">Estrategia para Derribar Barreras</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Resolver las dudas o preocupaciones que el cliente ideal pueda tener antes de tomar la decisión de contratar.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Abordar estas inquietudes de manera anticipada genera confianza y elimina barreras que podrían impedir la contratación del servicio.</p>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="fast-forward" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">FACILITADORES DE DECISIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">Estrategia para Acelerar el Cierre</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Dar información clara sobre aspectos clave como precios, horarios o flexibilidad, que ayuden al cliente a decidir más rápido.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Los clientes quieren sentirse seguros y bien informados antes de tomar una decisión. Explicar estas opciones les facilita dar el paso.</p>
        </div>

    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="users" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">PRUEBA SOCIAL</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">Estrategia para Generar Confianza</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Mostrar ejemplos de otras personas que han usado el servicio con buenos resultados para reforzar la confianza.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Los testimonios o reseñas ayudan a que los clientes potenciales confíen más, especialmente si tienen dudas sobre los resultados.</p>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md md:flex-1">
            <div class="flex items-center mb-4">
                <i data-lucide="settings-2" class="w-8 h-8 mr-4 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">PERSONALIZACIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)] -mt-2">Estrategia para Conectar y Diferenciar</p>
                </div>
            </div>
            <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
            <p class="text-gray-700 text-lg">Resaltar cómo el servicio puede adaptarse a las necesidades específicas del cliente, haciéndolo más relevante y único para él.</p>
            <h3 class="font-black text-[var(--color-secondary)] mt-4">Importancia</h3>
            <p class="text-gray-700 text-lg">Los clientes valoran sentirse especiales. Mostrar que el servicio se ajusta a lo que necesitan ayuda a diferenciarte de la competencia.</p>
        </div>

    </div>

    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="award" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('transformationAudioPlayer');
        const widget = document.getElementById('transformation-video-widget');
        const showContainer = document.getElementById('show-transformation-video-container');
        const widgetKey = 'hide_transformation-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="transformation-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="transformation-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>