document.addEventListener('DOMContentLoaded', function() {
    
    const editorContainer = document.getElementById('editor-de-texto-quill');
    const hiddenInput = document.getElementById('contenido-oculto');
    const charCountDisplay = document.getElementById('contador-caracteres');

    if (!editorContainer || !hiddenInput || !charCountDisplay) {
        return; 
    }

    const maxLength = parseInt(hiddenInput.maxLength) || 1500;

    // CONFIGURACIÓN ACTUALIZADA DE QUILL
    const quill = new Quill(editorContainer, {
        theme: 'snow', 
        placeholder: 'Escribe Aquí...',
        modules: {
            toolbar: [
                // Estilos de texto básicos
                ['bold', 'italic', 'underline'],
                
                // Citas
                ['blockquote'],

                // Encabezados (H1, H2, H3 y Texto Normal)
                [{ 'header': [1, 2, 3, false] }],

                // Listas
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],

                // Botón para limpiar formato
                ['clean']
            ]
        }
    });

    // Cargar contenido inicial si existe
    const initialContent = hiddenInput.value;
    if (initialContent) {
        quill.clipboard.dangerouslyPasteHTML(initialContent);
    }
    
    // Lógica del contador de caracteres
    const updateCharCount = () => {
        const text = quill.getText();
        const length = text.replace(/\s+$/, '').length; 
        
        charCountDisplay.textContent = `${length} / ${maxLength}`;
        
        if (length > maxLength) {
            charCountDisplay.classList.add('text-red-600', 'font-black'); 
        } else if (length > maxLength - 100) {
            charCountDisplay.classList.add('text-[var(--color-secondary)]', 'font-black'); 
            charCountDisplay.classList.remove('text-red-600');
        } else {
            charCountDisplay.classList.remove('text-[var(--color-secondary)]', 'text-red-600', 'font-black');
        }
    };

    // Sincronización con el input oculto
    quill.on('text-change', function() {
        let html = quill.root.innerHTML;
        // Limpieza de párrafo vacío por defecto de Quill
        if (html === '<p><br></p>') {
            html = '';
        }
        
        hiddenInput.value = html;
        updateCharCount();
    });

    // Inicializar contador
    updateCharCount();
});