<?php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$isAdmin  = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']) && ($_SESSION['loggedin'] ?? false) === true;
$isStaff  = isset($_SESSION['staff_id']) && !empty($_SESSION['staff_id']);
$isClient = isset($_SESSION['client_id']) && !empty($_SESSION['client_id']);

if (!$isAdmin && !$isStaff && !$isClient) {
    $isApiRequest = strpos($_SERVER['SCRIPT_NAME'], '/db/') !== false;

    if ($isApiRequest) {
        http_response_code(401);
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Acceso no autorizado. Su sesión puede haber expirado.'
        ]);
        exit();
    }

    session_unset();
    session_destroy();
    
    header('Location: login.php');
    exit();
}
?>