<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
require_once 'ia-marketing-results.php';
require_once 'media/videos-ia.php';

$client_name = $client_info['name'] ?? '';
$business_name = $client_info['business_name'] ?? '';
$phone = $client_info['phone'] ?? '';
$whatsapp = $client_info['whatsapp'] ?? '';
$email = $client_info['email'] ?? '';
$website = $client_info['website'] ?? '';
$operating_cities = $client_info['operating_cities'] ?? '';
$logo_url = $client_info['logo_url'] ?? '';
$value_proposition = $ia_results['value_proposition'] ?? '';
$current_client_profiles = $ia_results['ideal_client_profiles'] ?? [];
$social_links = $client_info['social_links'] ?? [];

if (ob_get_level() > 0) { ob_end_clean(); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Optimizador De Página De Facebook Con <?php echo htmlspecialchars($branding['iamarketing_name']); ?> Powered_by <?php echo htmlspecialchars($branding['powered_by']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://unpkg.com/imask"></script>
    
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    <script src="files/header-manager.js"></script>
    
    <style>
        .toggle-label { position: relative; display: inline-block; width: 50px; height: 28px; }
        .toggle-label input { opacity: 0; width: 0; height: 0; }
        .toggle-slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 28px; }
        .toggle-slider:before { position: absolute; content: ""; height: 20px; width: 20px; left: 4px; bottom: 4px; background-color: white; transition: .4s; border-radius: 50%; }
        input:checked + .toggle-slider { background-color: var(--color-primary); }
        input:checked + .toggle-slider:before { transform: translateX(22px); }

        .ai-response-formatted { border-top: 1px solid #e2e8f0; padding-top: 1.5rem; }
        .ai-response-formatted .ai-main-title { font-size: 2rem; font-weight: 900; color: var(--color-primary); text-align: center; margin-bottom: 0.5rem; line-height: 1.2; }
        .ai-response-formatted .ai-intro-text { font-size: 1.125rem; text-align: center; color: #4a5568; margin-bottom: 2.5rem; max-width: 800px; margin-left: auto; margin-right: auto; }
        .ai-response-formatted .ai-action-card { position: relative; background-color: #ffffff; border: 1px solid #e2e8f0; border-left-width: 4px; border-left-color: var(--color-secondary); border-radius: 0.75rem; padding: 1.5rem 2rem; margin-bottom: 2rem; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.05), 0 4px 6px -2px rgba(0, 0, 0, 0.05); transition: all 0.3s ease-in-out; }
        .ai-response-formatted .ai-action-title { font-size: 1.5rem; font-weight: 800; color: var(--color-primary); margin-bottom: 1rem; display: flex; align-items: center; }
        .ai-response-formatted .ai-action-title i { margin-right: 0.75rem; color: var(--color-secondary); flex-shrink: 0; }
        .ai-response-formatted .ai-action-why { display: flex; align-items: flex-start; margin-bottom: 1.5rem; line-height: 1.6; color: #374151; background-color: #f9fafb; padding: 1rem; border-radius: 0.5rem; border: 1px solid #e5e7eb; }
        .ai-response-formatted .ai-action-why i { flex-shrink: 0; margin-right: 0.75rem; color: var(--color-primary); margin-top: 3px; }
        .ai-response-formatted .ai-action-steps-title { font-weight: 700; color: var(--color-primary); margin-bottom: 1rem; text-transform: uppercase; font-size: 0.875rem; letter-spacing: 0.05em; border-bottom: 2px solid var(--color-highlight); padding-bottom: 4px; display: inline-block; }
        .ai-response-formatted .ai-action-steps { list-style: none; padding-left: 0; space-y-3; }
        .ai-response-formatted .ai-action-steps li { display: flex; align-items: flex-start; margin-bottom: 0.75rem; line-height: 1.6; color: #4a5568; }
        .ai-response-formatted .ai-action-steps i { color: #10b981; margin-right: 0.75rem; flex-shrink: 0; margin-top: 4px; }
        
        .delete-step-btn {
            position: absolute;
            top: 1rem;
            right: 1rem;
            border-radius: 50%;
            padding: 0.5rem;
            line-height: 1;
            transition: all 0.2s ease-in-out;
            cursor: pointer;
            opacity: 0; 
            pointer-events: none; 
        }
        
        .plan-is-saved .delete-step-btn {
            opacity: 1;
            pointer-events: auto;
        }
        .delete-step-btn:hover {
            transform: scale(1.1);
        }
        
        #save-plan-container {
            display: flex;
            justify-content: center;
            padding: 1rem;
            border-top: 1px solid #e5e7eb;
            background-color: #ffffff;
        }
        
        .plan-is-saved #save-plan-container {
            display: none;
        }
    </style>
</head>
<body data-page-title="Optimizador De Página De Facebook"
      data-page-subtitle="Ajusta Tu Página De Empresa Para Mejorar El Alcance Y La Interacción"
      data-page-icon="brain">

    <div id="toast-container" class="toast-container"></div>

    <?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    
    <?php include 'ia-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="fb-optimizer" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                    <div class="lg:col-span-3">
                        <div class="bg-white text-gray-800 rounded-xl shadow-md p-6 md:p-8">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                    <i data-lucide="clipboard-list" class="mr-3 text-[var(--color-secondary)]"></i>
                                    <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> COMPLETA TU DIAGNÓSTICO
                                </h2>
                                <p class="step-subtitle uppercase">Responde para evaluar tu Página de Negocio en Facebook.</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <div id="checklist-container"></div>
                        </div>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        
                        <?php if (!empty($logo_url)): ?>
                            <div class="bg-white p-4 rounded-xl shadow-md">
                                <img src="<?php echo htmlspecialchars($logo_url); ?>" 
                                     alt="Logotipo de <?php echo htmlspecialchars($business_name); ?>" 
                                     class="block mx-auto" 
                                     style="max-width: 250px;">
                            </div>
                        <?php endif; ?>
                        
                        <button id="open-plan-panel-btn" class="btn-copy bg-[var(--color-secondary)] text-white flex items-center justify-center w-full py-4 px-6 rounded-lg font-black text-lg uppercase gap-2 hover:scale-102 transition-transform">
                            <i data-lucide="shield-check" class="w-5 h-5"></i> <span>TU PLAN De Acción</span>
                        </button>
                        
                        <div class="w-full">
                            <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                                <div class="relative w-full" style="padding-bottom: 56.25%;">
                                    <video class="absolute top-0 left-0 w-full h-full object-cover" id="videoPlayer" controls controlslist="nodownload fullscreen" preload="metadata">
                                        <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                        TU NAVEGADOR NO SOPORTA LA ETIQUETA DE VIDEO
                                    </video>
                                    <div id="playOverlay" class="absolute inset-0 flex justify-center items-center cursor-pointer group">
                                        <img src="img/VideoLeccion-IAMarketing.jpg" alt="VideoLeccion - IAMarketing" class="absolute inset-0 w-full h-full object-cover">
                                        <div class="absolute inset-0 w-full h-full bg-black/40 transition-colors group-hover:bg-black/60"></div>
                                        <i data-lucide="play" class="relative w-16 h-16 text-white opacity-80 group-hover:opacity-100 transition-opacity"></i>
                                    </div>
                                </div>
                                <div class="p-4 text-white/90 text-sm flex items-center justify-between">
                                    <span class="inline-flex items-center gap-2">
                                        <i data-lucide="play-circle" class="w-4 h-4"></i> Video Tutorial
                                    </span>
                                    <span class="inline-flex items-center gap-2">
                                        <i data-lucide="clock" class="w-4 h-4"></i> 2:30 min
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-[var(--color-primary)] text-white rounded-xl shadow-md p-6 border-2 border-[var(--color-highlight)] flex flex-col items-center justify-center">
                            <h3 class="text-2xl font-bold mb-4 text-center">Puntuación De Tu Página</h3>
                            <div id="score-display" class="text-7xl font-black text-[var(--color-highlight)] mb-2">0%</div>
                            <div class="w-full bg-gray-700 rounded-full h-4">
                                <div id="progress-bar" class="bg-[var(--color-highlight)] h-4 rounded-full" style="width: 0%; transition: width 0.5s;"></div>
                            </div>
                        </div>

                    </div>
                
                    <div class="bg-white text-gray-800 rounded-xl shadow-md p-6 mt-8 lg:col-span-5">
                        <div class="step-header">
                            <h3 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i data-lucide="list-checks" class="mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">TAREAS:</span> TU PLAN DE ACCIÓN RÁPIDA
                            </h3>
                            <p class="step-subtitle uppercase">Una lista de acciones inmediatas basada en tu diagnóstico.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6 mt-6"></div>
                        <div id="task-list" class="space-y-4">
                            <p class="text-gray-500">Completa el diagnóstico para ver tus tareas pendientes aquí...</p>
                        </div>
                    </div>

                    <div id="ai-assistant-section" class="bg-white text-gray-800 rounded-xl shadow-md p-6 md:p-8 mt-8 lg:col-span-5">
                        <div class="step-header">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i data-lucide="bot" class="mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> RECIBE TU PLAN DE ACCIÓN
                            </h2>
                            <p class="step-subtitle uppercase">Basado en tu diagnóstico, la IA preparará un plan de acción detallado.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 items-center">

    <div class="flex flex-col justify-center items-center bg-[var(--color-primary)] p-6 rounded-xl">
        <i data-lucide="brain" class="w-24 h-24 md:w-32 md:h-32 text-white animate-pulse"></i>
        <p class="mt-4 text-white font-black text-xl uppercase tracking-wide">
            IA<span class="text-[var(--color-highlight)]">Marketing</span>™
        </p>
    </div>

    <div class="md:col-span-2 text-center md:text-left">
        
        <h3 class="text-2xl font-black text-gray-800 flex items-center justify-center md:justify-start mb-2 uppercase">
            <i data-lucide="bell-electric" class="w-6 h-6 text-[var(--color-secondary)] mr-2 flex-shrink-0"></i>
            Información Importante
        </h3>
        
        <p class="text-lg text-gray-700 mb-6">
            Para <b>optimizar tu página de Facebook</b>, <b>es importante</b> que la IA analice tu información actual. Con ese análisis, nuestra <b>inteligencia artificial</b> generará un <b>Plan de Acción</b> detallado, para que puedas corregir cada punto débil y mejorar tu presencia social.
        </p>
        
        <div class="flex justify-center md:justify-start">
            <button id="get-ai-advice-btn" type="submit" class="w-full sm:w-auto bg-[var(--color-highlight)] text-[var(--color-primary)] font-black py-4 px-6 rounded-lg hover:scale-105 transition-transform text-lg flex items-center justify-center uppercase">
                
                <i data-lucide="arrow-big-right-dash" class="w-6 h-6"></i>
                
                <span id="btn-text">GENERAR TU PLAN DE ACCIÓN CON IA</span>
                
                <div id="loader-container" class="hidden ml-3"></div>
            </button>
        </div>
    </div>
    
</div>
</section>
               
                        <div id="ai-response-container" class="mt-8 hidden">
                            <div id="ai-response-content" class="ai-response-formatted"></div>
                            
                            <div id="save-plan-container">
                                <button id="save-plan-btn" class="btn-copy bg-[var(--color-secondary)] text-white font-black py-4 px-8 rounded-lg text-lg flex items-center justify-center gap-2 uppercase hover:scale-105 transition-transform">
                                    <i data-lucide="save"></i>
                                    <span>Guardar Plan de Acción</span>
                                </button>
                            </div>
                        </div>
                        </div>
                </div>
        </div>
    </main>
</div>

<div id="plan-panel-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden" aria-hidden="true"></div>

<aside id="plan-panel" class="fixed top-0 right-0 h-full w-full lg:w-1/3 bg-[var(--color-background)] z-50 transform translate-x-full transition-transform duration-300 ease-in-out shadow-2xl flex flex-col">
    
    <div class="flex-shrink-0 flex justify-between items-center p-4 border-b border-gray-200 bg-[var(--color-primary)] text-white shadow z-20">
        <h3 class="text-3xl font-black text-[var(--color-highlight)] flex items-center uppercase">
            <i data-lucide="shield-check" class="w-8 h-8 mr-2 text-white"></i>
            TU PLAN GUARDADO
        </h3>
        <button id="close-plan-panel-btn" class="bg-[var(--color-secondary)] text-white hover:text-[var(--color-highlight)] p-1 rounded-md transition-colors duration-200">
            <i data-lucide="x" class="w-8 h-8"></i>
        </button>
    </div>

    <div class="flex-grow overflow-y-auto p-6 relative">
        
        <div id="plan-panel-content" class="bg-white p-6 rounded-xl shadow-md transition duration-300 min-h-[200px]">
            <div class="flex flex-col items-center justify-center h-40 text-gray-400">
                <i data-lucide="loader-2" class="w-8 h-8 animate-spin mb-2"></i>
                <span class="text-sm font-bold uppercase">Cargando plan...</span>
            </div>
        </div>
        
    </div>

    <div class="p-4 bg-gray-100 border-t border-gray-200 flex-shrink-0 z-10"> 
        <button type="button" onclick="document.getElementById('close-plan-panel-btn').click()" class="w-full btn-cancel uppercase flex items-center justify-center gap-2">
            <i data-lucide="x-circle" class="w-5 h-5"></i> CERRAR PANEL DE RESULTADOS
        </button>
    </div>

</aside>

<div id="confirmation-modal" class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center hidden z-[100]"> 
    <div class="bg-white p-8 rounded-xl w-full max-w-sm m-4 transform transition-all duration-300 scale-95 opacity-0 text-center">
        <div class="flex justify-center mb-4">
            <i id="modal-icon" data-lucide="alert-triangle" class="w-16 h-16 text-[var(--color-secondary)]"></i>
        </div>
        <h3 id="modal-title" class="text-2xl font-bold text-[var(--color-primary)] mb-4 uppercase">CONFIRMAR ACCIÓN</h3>
        <p id="modal-message" class="text-gray-700 mb-6 uppercase">¿Estás seguro?</p>
        <div class="flex flex-col sm:flex-row justify-center space-y-2 sm:space-y-0 sm:space-x-4">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase w-full sm:w-auto" id="modal-cancel-btn">CANCELAR</button>
            <button type="button" class="btn-secondary font-bold text-white py-2 px-4 rounded-lg uppercase w-full sm:w-auto" id="modal-confirm-btn">CONFIRMAR</button>
        </div>
    </div>
</div>

<script type="module">
// --- CARGA DOMCONTENT ---
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();
    
    // --- MANEJADORES DE MENÚ Y UI BÁSICA ---
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');

    mobileMenuButton.addEventListener('click', () => {
        sidebar.classList.toggle('-translate-x-full');
        sidebarOverlay.classList.toggle('hidden');
    });

    sidebarOverlay.addEventListener('click', () => {
        sidebar.classList.add('-translate-x-full');
        sidebarOverlay.classList.add('hidden');
    });

    // --- NOTIFICACIONES TOAST ---
    function showSafeToast(message, type) {
        if (typeof showToast === 'function') {
            showToast(message, type);
        } else {
            console.warn(`Toast: ${type} - ${message}`);
        }
    }
    
    // --- VIDEO PLAYER ---
    const playOverlay = document.getElementById('playOverlay');
    const videoPlayer = document.getElementById('videoPlayer');
    
    if(playOverlay && videoPlayer) {
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.play();
        });
    }

    // --- LÓGICA DEL MODAL DE CONFIRMACIÓN ---
    const modal = document.getElementById('confirmation-modal');
    const modalBox = modal.querySelector('div:first-of-type');
    const modalIcon = document.getElementById('modal-icon');
    const modalTitle = document.getElementById('modal-title');
    const modalMessage = document.getElementById('modal-message');
    const modalCancelBtn = document.getElementById('modal-cancel-btn');
    const modalConfirmBtn = document.getElementById('modal-confirm-btn');
    let onConfirmCallback = null; 

    function openModal({ title, message, icon, confirmText, confirmClass, onConfirm }) {
        modalTitle.textContent = title;
        modalMessage.innerHTML = message; // Usar innerHTML para saltos de línea <br>
        modalIcon.setAttribute('data-lucide', icon);
        lucide.createIcons({ nodes: [modalIcon] });

        modalConfirmBtn.textContent = confirmText || 'CONFIRMAR';
        // Resetear clases
        modalConfirmBtn.className = 'btn-secondary font-bold text-white py-2 px-4 rounded-lg uppercase w-full sm:w-auto'; 
        
        if (confirmClass === 'danger') {
            modalConfirmBtn.classList.add('bg-[var(--color-secondary)]', 'hover:bg-[var(--color-secondary)]');
            modalConfirmBtn.classList.remove('btn-secondary'); 
        }
        onConfirmCallback = onConfirm; 
        modal.classList.remove('hidden');
        setTimeout(() => modalBox.classList.remove('scale-95', 'opacity-0'), 50);
        document.body.style.overflow = 'hidden';
    }

    function closeModal() {
        modalBox.classList.add('scale-95', 'opacity-0');
        setTimeout(() => {
            modal.classList.add('hidden');
            document.body.style.overflow = '';
        }, 300);
        onConfirmCallback = null;
    }

    modalCancelBtn.addEventListener('click', closeModal);
    modalConfirmBtn.addEventListener('click', () => {
        if (typeof onConfirmCallback === 'function') {
            onConfirmCallback(); // Ejecutar la acción guardada
        }
        closeModal();
    });

    // --- LÓGICA DEL PANEL LATERAL DE PLAN ---
    const openPanelBtn = document.getElementById('open-plan-panel-btn');
    const closePanelBtn = document.getElementById('close-plan-panel-btn');
    const panelOverlay = document.getElementById('plan-panel-overlay');
    const planPanel = document.getElementById('plan-panel');
    const panelContent = document.getElementById('plan-panel-content');
    
    // --- ESTADO GLOBAL DE LA HERRAMIENTA ---
    let currentPlan = null; // Plan recién generado, no guardado
    let savedPlan = null;   // Plan cargado desde la BD (Objeto JS)
    
    function openPlanPanel() {
        planPanel.classList.remove('translate-x-full');
        panelOverlay.classList.remove('hidden');
        loadDataIntoPanel(); // Recargar el contenido del panel cada vez que se abre
    }

    function closePlanPanel() {
        planPanel.classList.add('translate-x-full');
        panelOverlay.classList.add('hidden');
    }

    openPanelBtn.addEventListener('click', openPlanPanel);
    closePanelBtn.addEventListener('click', closePlanPanel);
    panelOverlay.addEventListener('click', closePlanPanel);

    // --- LÓGICA DEL OPTIMIZADOR DE FACEBOOK ---
    
    // --- Datos del Checklist ---
    const checklistData = [
        { id: 'foto_perfil', question: '¿Tu foto de perfil es tu logo en alta calidad?', recommendation: 'Usa un logo claro y reconocible. Es la imagen que te representa en toda la plataforma.', category: 'Identidad Visual' },
        { id: 'foto_portada', question: '¿Tu foto de portada es atractiva y comunica tu valor principal?', recommendation: 'Usa una imagen de alta calidad que muestre tu producto, servicio o que refuerce tu marca. Cámbiala estacionalmente.', category: 'Identidad Visual' },
        { id: 'nombre_usuario', question: '¿Tienes un nombre de usuario (@) corto, memorable y fácil de encontrar?', recommendation: 'Configura un nombre de usuario (ej: @TuNegocio) para tener una URL limpia (facebook.com/TuNegocio).', category: 'Información Básica' },
        { id: 'cta_boton', question: '¿Está configurado el botón de Llamada a la Acción principal?', recommendation: 'Define el botón principal de tu página (ej: "Enviar Mensaje", "Contactar", "Comprar") para guiar a los visitantes.', category: 'Funcionalidad' },
        { id: 'informacion', question: '¿Has completado toda la sección de "Información" (contacto, web, ubicación)?', recommendation: 'Rellena todos los campos posibles: descripción, email, teléfono, web, horario. Da credibilidad y facilita el contacto.', category: 'Información Básica' },
        { id: 'publicacion_fijada', question: '¿Tienes una publicación importante fijada en la parte superior?', recommendation: 'Fija una publicación con tu oferta más importante, un video de bienvenida o información clave.', category: 'Contenido Estratégico' },
        { id: 'frecuencia', question: '¿Publicas contenido de valor al menos 3-4 veces por semana?', recommendation: 'Mantén una frecuencia de publicación constante para que tu audiencia no te olvide y para alimentar el algoritmo.', category: 'Actividad' },
        { id: 'interaccion', question: '¿Respondes a los comentarios y mensajes en menos de 24 horas?', recommendation: 'La interacción es clave. Responde preguntas y agradece comentarios para crear una comunidad.', category: 'Gestión de Comunidad' },
        { id: 'video', question: '¿Utilizas formatos de video (Reels, Lives, videos normales) en tu estrategia?', recommendation: 'El video es el formato con mayor alcance en Facebook. Intenta crear videos cortos o tutoriales.', category: 'Contenido Estratégico' },
        { id: 'servicios', question: '¿Has configurado la pestaña de "Servicios" o "Tienda"?', recommendation: 'Usa las pestañas de Servicios o Tienda para mostrar lo que ofreces de forma organizada, como un catálogo digital.', category: 'Funcionalidad' },
    ];

    // --- Selectores de Elementos ---
    const checklistContainer = document.getElementById('checklist-container');
    const progressBar = document.getElementById('progress-bar');
    const scoreDisplay = document.getElementById('score-display');
    const taskList = document.getElementById('task-list');
    const getAiAdviceBtn = document.getElementById('get-ai-advice-btn');
    const aiResponseContainer = document.getElementById('ai-response-container');
    const aiResponseContent = document.getElementById('ai-response-content');
    const savePlanBtn = document.getElementById('save-plan-btn');

    // --- Renderizado Inicial del Checklist ---
    function renderChecklist() {
        checklistContainer.innerHTML = checklistData.map(item => {
            const formattedQuestion = item.question.charAt(0).toUpperCase() + item.question.slice(1);
            return `
                <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center border-b border-gray-200 py-3 gap-3">
                    <p class="font-semibold text-lg text-[var(--color-primary)]">${formattedQuestion}</p>
                    <div class="flex items-center flex-shrink-0 space-x-3 self-end sm:self-center">
                        <span class="text-gray-500 text-sm">No</span>
                        <label class="toggle-label">
                            <input type="checkbox" name="${item.id}" class="toggle-switch">
                            <span class="toggle-slider"></span>
                        </label>
                        <span class="font-bold text-[var(--color-primary)] text-sm">Sí</span>
                    </div>
                </div>
            `;
        }).join('');
    }

    // --- Actualización de UI (Checklist, Score, Tareas) ---
    function updateProgressAndTasks() {
        const totalQuestions = checklistData.length;
        const yesAnswers = document.querySelectorAll('input.toggle-switch:checked').length;
        const percentage = totalQuestions > 0 ? Math.round((yesAnswers / totalQuestions) * 100) : 0;
        
        progressBar.style.width = `${percentage}%`;
        scoreDisplay.textContent = `${percentage}%`;

        const pendingItems = checklistData.filter(item => !document.querySelector(`input[name="${item.id}"]`).checked);

        if (pendingItems.length > 0) {
            taskList.innerHTML = pendingItems.map(item => `
                <div class="bg-gray-50 p-4 rounded-lg shadow-sm border-l-4 border-[var(--color-secondary)] flex items-start space-x-4">
                    <div class="flex-shrink-0 pt-1"><i data-lucide="alert-triangle" class="text-[var(--color-secondary)] w-5 h-5"></i></div>
                    <div class="flex-grow">
                        <span class="text-xs font-bold uppercase text-[var(--color-secondary)] tracking-wider">${item.category}</span>
                        <p class="text-gray-700 font-medium mt-1">${item.recommendation}</p>
                    </div>
                </div>
            `).join('');
        } else {
            taskList.innerHTML = `
                <div class="bg-green-100 p-4 rounded-lg border-l-4 border-green-500 flex items-center space-x-4">
                    <i data-lucide="award" class="text-green-600 w-6 h-6"></i>
                    <div>
                        <h4 class="font-bold text-green-800">¡Felicidades! Tu página está bien optimizada.</h4>
                        <p class="text-green-700">Has cubierto todos los puntos clave. ¡Sigue publicando con constancia!</p>
                    </div>
                </div>
            `;
        }
        lucide.createIcons();

        if (pendingItems.length > 0) { // Habilitar el botón IA si hay tareas pendientes
            getAiAdviceBtn.disabled = false;
            getAiAdviceBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        } else { // Deshabilitar si el score es 100%
            getAiAdviceBtn.disabled = true;
            getAiAdviceBtn.classList.add('opacity-50', 'cursor-not-allowed');
        }
    }
    
    // --- Lógica de IA (Generación de Plan) ---
    function setProcessingState(isProcessing) {
        const btnText = document.getElementById('btn-text');
        const loaderContainer = document.getElementById('loader-container');
        
        getAiAdviceBtn.disabled = isProcessing;

        if (isProcessing) {
            getAiAdviceBtn.classList.add('opacity-50', 'cursor-not-allowed');
            loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
            loaderContainer.classList.remove('hidden');
            aiResponseContainer.classList.add('hidden');
            aiResponseContent.innerHTML = '';
            
            const messages = ["Analizando tareas...", "Consultando IA Marketing...", "Creando tu plan de acción...", "Casi está listo..."];
            let messageIndex = 0;
            btnText.textContent = messages[messageIndex];
            if (window.loadingInterval) clearInterval(window.loadingInterval);
            window.loadingInterval = setInterval(() => {
                messageIndex = (messageIndex + 1) % messages.length;
                btnText.textContent = messages[messageIndex];
            }, 2500);

        } else {
            if (window.loadingInterval) clearInterval(window.loadingInterval);
            loaderContainer.classList.add('hidden');
            btnText.textContent = 'GENERAR PLAN DE ACCIÓN';
            updateProgressAndTasks(); 
        }
    }
    
    /**
     * Renderiza el plan de acción en HTML.
     * @param {object} planObject - El objeto del plan (parseado, no string).
     * @param {boolean} isSaved - True si el plan viene de la BD, false si es nuevo.
     */
    function renderPlan(planObject, isSaved = false) {
        if (!planObject || !planObject.action_points) {
            aiResponseContent.innerHTML = `<p class="text-[var(--color-secondary)]">Error: El plan recibido está vacío o tiene un formato incorrecto.</p>`;
            return;
        }

        let html = '';
        if (planObject.main_title) html += `<h1 class="ai-main-title font-black uppercase">${planObject.main_title}</h1>`;
        if (planObject.intro_text) html += `<p class="ai-intro-text">${planObject.intro_text}</p>`;

        if (planObject.action_points.length === 0) {
             html += `<div class="bg-green-100 p-4 rounded-lg border-l-4 border-green-500 flex items-center space-x-4">
                    <i data-lucide="award" class="text-green-600 w-6 h-6"></i>
                    <div>
                        <h4 class="font-bold text-green-800">¡Plan Completado!</h4>
                        <p class="text-green-700">Has completado todas las tareas de tu plan de acción. ¡Excelente trabajo!</p>
                    </div>
                </div>`;
        }

        planObject.action_points.forEach(item => {
            html += `
                <div class="ai-action-card" data-step-id="${item.id}">
                    <button class="delete-step-btn" data-step-id="${item.id}" title="Completado (Eliminar Tarea)">
                        <i data-lucide="trash-2" class="w-6 h-6 pointer-events-none"></i>
                    </button>
                    <h3 class="ai-action-title font-black uppercase"><i data-lucide="clipboard-check"></i>${item.title}</h3>
                    <div class="ai-action-why">
                        <i data-lucide="info" class="w-5 h-5"></i>
                        <div><strong>Por qué es importante:</strong> ${item.why}</div>
                    </div>
                    <div>
                        <h4 class="ai-action-steps-title">Pasos para implementarlo:</h4>
                        <ul class="ai-action-steps">
                            ${item.steps.map(step => `<li><i data-lucide="check-circle" class="w-5 h-5"></i><span>${step}</span></li>`).join('')}
                        </ul>
                    </div>
                </div>`;
        });
        
        aiResponseContent.innerHTML = html;
        aiResponseContainer.classList.remove('hidden');

        // Controla la visibilidad de los botones
        if (isSaved) {
            aiResponseContainer.classList.add('plan-is-saved');
        } else {
            aiResponseContainer.classList.remove('plan-is-saved');
        }

        lucide.createIcons();
        
        // Scroll al plan
        setTimeout(() => {
             aiResponseContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 100);
    }

    // Esta es la lógica real de generación, separada para el modal
    async function actualGetAIAdvice() {
        const pendingTasks = checklistData
            .filter(item => !document.querySelector(`input[name="${item.id}"]`).checked)
            .map(item => `(${item.category}) ${item.question} - ${item.recommendation}`);

        if (pendingTasks.length === 0) {
            showSafeToast('Tu página ya está optimizada, no hay tareas que enviar a la IA.', 'info');
            return;
        }

        setProcessingState(true);

        try {
            const payload = { pending_tasks: pendingTasks };
            const response = await fetch('api/api-facebook-page-optimizer.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });

            if (!response.ok) {
                const errorData = await response.json().catch(() => null);
                const errorMsg = errorData?.error || `Error del servidor: ${response.status}`;
                throw new Error(errorMsg);
            }

            const data = await response.json(); 
            
            if (data.error) throw new Error(data.error);
            if (!data.action_points) throw new Error("La IA no devolvió un plan de acción válido.");

            currentPlan = data; // Guardar en el estado "vivo" (no guardado)
            renderPlan(currentPlan, false); // Renderizar como plan nuevo (isSaved = false)
            showSafeToast('¡Plan de acción generado con éxito!', 'success');

        } catch (error) {
            console.error("Error del Asistente IA (Facebook):", error);
            aiResponseContent.innerHTML = `<div class="bg-[var(--color-secondary)] text-center p-4 text-white rounded-lg border border-[var(--color-secondary)]"><p><strong>Error:</strong> No se pudo generar la estrategia.</p><p class="mt-2 text-sm">${error.message}</p></div>`;
            aiResponseContainer.classList.remove('hidden');
        } finally {
            setProcessingState(false);
        }
    }

    // --- LÓGICA DE BASE DE DATOS (Panel y Guardado de Plan) ---

    function loadDataIntoPanel() {
        // Esta función ahora solo mira la variable 'savedPlan'
        if (savedPlan) {
            panelContent.innerHTML = `
                <div class="space-y-4">
                    <h4 class="text-xl font-black uppercase text-[var(--color-primary)]">Tu Plan De Acción</h4>
                    
                    <div class="bg-gray-50 p-6 rounded-xl border-l-4 border-[var(--color-highlight)] shadow-inner mb-6">
                        <p class="text-3xl font-black uppercase text-[var(--color-primary)] mb-4">${savedPlan.main_title || 'Plan de Acción'}</p>
                        
                        <p class="text-lg font-semibold text-gray-700 mb-2">Tareas Pendientes:</p>
                        <span class="text-4xl font-black text-[var(--color-primary)]">${savedPlan.action_points.length}</span>
                    </div>

                    <p class="text-sm text-gray-600">Puedes cargar tu plan guardado para verlo (reemplazará el plan actual en pantalla) o eliminarlo de la base de datos.</p>
                    
                    <div class="mt-3 flex flex-col space-y-2">
                        <button id="panel-btn-cargar" class="btn-copy bg-[var(--color-primary)] text-white hover:bg-[var(--color-primary)]/90 flex-1">
                            <i data-lucide="eye"></i> CARGAR PLAN GUARDADO
                        </button>
                        <button id="panel-btn-eliminar" class="btn-copy bg-[var(--color-secondary)] text-white hover:bg-[var(--color-secondary)]">
                            <i data-lucide="trash-2"></i> ELIMINAR PLAN
                        </button>
                    </div>
                </div>
            `;
        } else {
            panelContent.innerHTML = `
                <div class="text-center p-4 border border-dashed rounded-lg">
                    <i data-lucide="info" class="w-12 h-12 text-gray-400 mx-auto mb-3"></i>
                    <h4 class="text-xl font-bold text-gray-800 mb-2">No hay plan guardado</h4>
                    <p class="text-gray-500 mb-4">
                        Completa el test y genera un plan de acción. Luego podrás guardarlo usando el botón "Guardar Plan" que aparecerá con los resultados.
                    </p>
                </div>
            `;
        }
        lucide.createIcons();
        assignPanelButtonEvents();
    }

    function assignPanelButtonEvents() {
        const btnCargar = document.getElementById('panel-btn-cargar');
        const btnEliminar = document.getElementById('panel-btn-eliminar');

        if (btnCargar) {
            btnCargar.addEventListener('click', () => {
                if(savedPlan) {
                    currentPlan = null; // Limpiar plan no guardado
                    renderPlan(savedPlan, true); // Renderizar el plan guardado
                    showSafeToast('Plan guardado cargado', 'success');
                    closePlanPanel();
                }
            });
        }

        if (btnEliminar) {
            btnEliminar.addEventListener('click', () => {
                // MODAL: Confirmar eliminación total
                openModal({
                    title: 'CONFIRMAR ELIMINACIÓN',
                    message: '¿Estás seguro de que quieres eliminar tu Plan de Acción? <br> Esta acción no se puede deshacer.',
                    icon: 'alert-triangle',
                    confirmText: 'SÍ, ELIMINAR',
                    confirmClass: 'danger',
                    onConfirm: deletePlanFromDB // Llamar a la función de borrado
                });
            });
        }
    }

    /**
     * Esta es la lógica real de guardado, separada para el modal
     * @param {object} planObject - El objeto del plan a guardar.
     * @param {string} mode - 'create' o 'update'.
     */
    async function proceedWithSave(planObject, mode) {
        const payload = { ai_plan_json: planObject };
        const url = (mode === 'create') 
            ? 'api-db/ia-facebook-page-optimizer-create.php' 
            : 'api-db/ia-facebook-page-optimizer-update.php';

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload) 
            });

            const result = await response.json();

            if (response.ok && result.success) {
                showSafeToast(result.message, 'success');
                
                // Sincronizar el estado
                savedPlan = JSON.parse(JSON.stringify(planObject)); // Copia profunda
                currentPlan = null; // Limpiar el plan "temporal"
                
                // Volver a renderizar para que muestre los botones de borrado
                renderPlan(savedPlan, true);
                loadDataIntoPanel(); // Recargar panel lateral
            
            } else if (response.status === 409) { // Conflicto: 'create' falló
                // Si 'create' falló porque ya existía, reintentar como 'update'
                await proceedWithSave(planObject, 'update');
            } else {
                throw new Error(result.message || 'Error desconocido al guardar.');
            }

        } catch (error) {
            console.error('Error al guardar el plan:', error);
            showSafeToast(`Error: ${error.message}`, 'error');
        }
    }


    /**
     * Guarda o actualiza el plan en la BD, AHORA CON MODAL
     * @param {object} planObject - El objeto del plan a guardar.
     *S
     * @param {string} mode - 'create' (guardar nuevo) o 'update' (actualizar existente).
     */
    async function savePlanToDB(planObject, mode = 'create') {
        if (!planObject) {
            showSafeToast('No hay ningún plan para guardar.', 'error');
            return;
        }

        // Si el plan ya existe Y estamos intentando 'crear' (Guardar nuevo)
        // entonces es una sobrescritura.
        if (savedPlan && mode === 'create') {
            // MODAL: Confirmar sobrescritura
            openModal({
                title: 'CONFIRMAR SOBRESCRITURA',
                message: 'Ya tienes un plan guardado. <br> ¿Deseas reemplazarlo con este nuevo plan?',
                icon: 'refresh-cw',
                confirmText: 'SÍ, REEMPLAZAR',
                confirmClass: 'danger',
                onConfirm: () => proceedWithSave(planObject, 'update') // Si confirma, forzar 'update'
            });
        } else {
            // Si es 'update' (como al borrar un paso) o es 'create' pero no hay plan guardado,
            // proceder directamente sin preguntar.
            await proceedWithSave(planObject, savedPlan ? 'update' : 'create');
        }
    }

    // ELIMINAR PLAN COMPLETO
    async function deletePlanFromDB() {
        try {
            const response = await fetch('api-db/ia-facebook-page-optimizer-delete.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' }
            });
            const result = await response.json();

            if (response.ok && result.success) {
                showSafeToast(result.message, 'success');
                
                // Actualizar estado global
                savedPlan = null; 
                currentPlan = null;
                
                // Limpiar UI
                aiResponseContainer.classList.add('hidden');
                aiResponseContent.innerHTML = '';
                
                // Recargar el panel (que ahora mostrará "sin plan")
                loadDataIntoPanel();
            } else {
                throw new Error(result.message || 'Error desconocido al eliminar.');
            }
        } catch (error) {
            console.error('Error al eliminar el plan:', error);
            showSafeToast(`Error: ${error.message}`, 'error');
        }
    }

    /**
     * Carga el plan desde la BD al iniciar la página
     */
    async function loadSavedPlanFromDB() {
        try {
            const response = await fetch('api-db/ia-facebook-page-optimizer-fetch.php', { cache: "no-store" });
            if (!response.ok) {
                throw new Error('Error de red al buscar el plan.');
            }
            
            const result = await response.json();
            
            if (result.success && result.data && result.data.ai_plan_json) {
                // El JSON de la BD es un STRING, hay que parsearlo
                const planObject = JSON.parse(result.data.ai_plan_json);
                if (planObject) {
                    savedPlan = planObject; // Asignar al estado global
                    renderPlan(savedPlan, true); // Renderizarlo como "guardado"
                    showSafeToast('Plan guardado cargado.', 'success');
                }
            } else {
                // No hay plan guardado, no hacer nada.
                console.log('No se encontró un plan guardado.');
                loadDataIntoPanel(); // Cargar panel para que muestre "No hay plan"
            }
        } catch (error) {
            console.error('Error al cargar el plan guardado:', error);
            showSafeToast('No se pudo cargar tu plan guardado.', 'error');
        }
    }


    /**
     * Función de inicialización principal
     */
    async function initializeTool() {
        // 1. Renderizar el checklist
        renderChecklist();
        
        // 2. Cargar el plan guardado (si existe) desde la BD
        await loadSavedPlanFromDB(); 

        // 3. Actualizar la UI del checklist (score, tareas)
        updateProgressAndTasks(); 

        // 4. Listeners (el resto del código)
        checklistContainer.addEventListener('input', (e) => {
            if (e.target.classList.contains('toggle-switch')) {
                updateProgressAndTasks();
            }
        });
        
        // MODAL: Confirmar Generar Nuevo Plan
        getAiAdviceBtn.addEventListener('click', () => {
            if (savedPlan) {
                openModal({
                    title: 'CONFIRMAR NUEVO PLAN',
                    message: 'Ya tienes un plan guardado. <br> ¿Generar un plan nuevo? (El plan actual en pantalla se reemplazará)',
                    icon: 'refresh-cw',
                    confirmText: 'SÍ, GENERAR',
                    confirmClass: 'danger',
                    onConfirm: actualGetAIAdvice // Llamar a la función de generación
                });
            } else {
                actualGetAIAdvice(); // Si no hay plan guardado, generar directo
            }
        });
        
        // MODAL: Confirmar Guardar/Sobrescribir
        savePlanBtn.addEventListener('click', () => {
            if (currentPlan) {
                // La función 'savePlanToDB' ahora maneja el modal de sobrescritura
                savePlanToDB(currentPlan, 'create'); 
            }
        });

        // MODAL: Confirmar Borrar Paso
        aiResponseContent.addEventListener('click', (e) => {
            const deleteButton = e.target.closest('.delete-step-btn');
            
            // Solo reaccionar si el plan está guardado (se muestran los botones)
            if (deleteButton && savedPlan) {
                const stepId = deleteButton.dataset.stepId;
                
                openModal({
                    title: 'CONFIRMAR TAREA COMPLETADA',
                    message: '¿Estás seguro de que quieres marcar esta tarea como completada y eliminarla del plan?',
                    icon: 'check-square',
                    confirmText: 'SÍ, COMPLETADA',
                    confirmClass: 'danger', // Usar rojo para "eliminar"
                    onConfirm: () => {
                        const stepElement = document.querySelector(`.ai-action-card[data-step-id="${stepId}"]`);

                        // 1. Eliminar del objeto 'savedPlan'
                        const originalStepCount = savedPlan.action_points.length;
                        savedPlan.action_points = savedPlan.action_points.filter(step => step.id !== stepId);
                        const newStepCount = savedPlan.action_points.length;

                        if (originalStepCount === newStepCount) {
                            console.warn(`No se encontró el paso ${stepId} en savedPlan.`);
                            return; // No hacer nada si no se encontró
                        }

                        // 2. Ocultar y eliminar del DOM
                        if (stepElement) {
                            stepElement.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
                            stepElement.style.opacity = '0';
                            stepElement.style.transform = 'scale(0.95)';
                            setTimeout(() => stepElement.remove(), 300);
                        }

                        // 3. Guardar el plan modificado (con el paso eliminado) en la BD
                        // Usamos 'update'. Esta llamada ya no pregunta, va directo.
                        proceedWithSave(savedPlan, 'update'); 
                        showSafeToast('Tarea completada y guardada.', 'success');
                        
                        // Actualizar el contador en el panel lateral
                        loadDataIntoPanel();
                    }
                });
            }
        });
    }

    // --- INICIALIZACIÓN ---
    initializeTool();

});
</script>
<script src="files/toast.js"></script>
</body>
</html>