<?php
// descargar-imagen.php

// 1. Verificamos si se proporcionó una URL de imagen.
if (isset($_GET['url']) && !empty($_GET['url'])) {
    
    $imageUrl = $_GET['url'];
    $imageTitle = isset($_GET['title']) ? $_GET['title'] : 'imagen-descargada';

    // 2. Medida de seguridad básica: Asegurarse de que la URL sea válida 
    // y (opcionalmente) que provenga de un dominio permitido.
    if (!filter_var($imageUrl, FILTER_VALIDATE_URL) || strpos($imageUrl, 'picsum.photos') === false) {
        http_response_code(400);
        die('Error: URL de imagen no válida o no permitida.');
    }

    // 3. Obtenemos el contenido de la imagen desde la URL remota.
    $imageData = @file_get_contents($imageUrl);

    if ($imageData === false) {
        http_response_code(404);
        die('Error: No se pudo encontrar la imagen.');
    }

    // 4. Preparamos un nombre de archivo limpio y seguro.
    $filename = preg_replace('/[^a-zA-Z0-9-_\.]/', '', $imageTitle) . '.jpg';

    // 5. ¡La Magia! Enviamos las cabeceras (headers) que fuerzan la descarga.
    header('Content-Description: File Transfer');
    header('Content-Type: image/jpeg'); // Le decimos al navegador que es una imagen JPEG.
    header('Content-Disposition: attachment; filename="' . $filename . '"'); // La orden clave: "adjunto para descargar".
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . strlen($imageData)); // Informamos el tamaño del archivo.
    
    // 6. Finalmente, enviamos los datos de la imagen al navegador.
    echo $imageData;
    exit;

} else {
    // Si no se proporciona una URL, enviamos un error.
    http_response_code(400);
    echo 'Error: No se especificó la URL de la imagen a descargar.';
}
?>