<?php
require_once __DIR__ . '/../config.php'; 
require_once __DIR__ . '/../db/db-business_config.php';
ob_clean();

header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['error' => 'Method Not Allowed.']);
        exit;
    }

    // Verificamos que AMBAS constantes existan (cada una de su archivo)
    if (!defined('GEMINI_API_KEY') || empty(GEMINI_API_KEY)) {
        http_response_code(500);
        // El error ahora es más específico
        echo json_encode(['error' => 'Gemini API key is not configured in config.php.']);
        exit;
    }

    if (!defined('BUSINESS_NAME') || empty(BUSINESS_NAME)) {
        http_response_code(500);
        // Este es el error que estabas viendo
        echo json_encode(['error' => 'BUSINESS_NAME is not configured or found. Check db-business_config.php.']);
        exit;
    }

    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE || !isset($input['service']) || !isset($input['experience']) || !isset($input['feeling'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing required fields.']);
        exit;
    }

    // --- ESTE PROMPT YA ES CORRECTO ---
    // Utiliza la constante BUSINESS_NAME que ya cargamos
    $prompt = "Actúa como un **cliente real, extremadamente satisfecho**, que quiere dejar una reseña de 5 estrellas útil y auténtica. El tono debe ser genuino y persuasivo.

    --- INFORMACIÓN DEL CLIENTE Y NEGOCIO ---
    1.  **Nombre del Negocio:** " . BUSINESS_NAME . "
    2.  **Servicio Recibido:** {$input['service']}
    3.  **Calificación de la Experiencia:** {$input['experience']}
    4.  **Principal Beneficio/Sentimiento:** {$input['feeling']}
    
    --- TU TAREA ---
    Basado en esta información, redacta **dos reseñas de 5 estrellas distintas y convincentes**.
    
    **RESEÑA 1 (Enfocada en el Resultado):**
    -   Debe ser un párrafo conciso y directo.
    -   Debe **mencionar el nombre del negocio ('" . BUSINESS_NAME . "')** de forma natural.
    
    **RESEÑA 2 (Enfocada en la Experiencia):**
    -   Debe ser un párrafo un poco más personal.
    -   Debe **mencionar el nombre del negocio ('" . BUSINESS_NAME . "')** de forma natural.
    
    --- REGLAS IMPORTANTES ---
    -   **SÍ** debes incluir el nombre del negocio ('" . BUSINESS_NAME . "') en **AMBAS** reseñas.
    -   **NO** uses emojis ni hashtags.
    -   Ambas reseñas deben sonar naturales y humanas.
    -   La respuesta debe ser un **objeto JSON válido** y en **inglés**.";

    $apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash:generateContent?key=' . GEMINI_API_KEY;

    $payload = [
        'contents' => [['parts' => [['text' => $prompt]]]],
        'generationConfig' => [
            'response_mime_type' => 'application/json',
            'response_schema' => [
                'type' => 'OBJECT',
                'properties' => [
                    'review_1' => ['type' => 'STRING'],
                    'review_2' => ['type' => 'STRING']
                ],
                'required' => ['review_1', 'review_2']
            ]
        ]
    ];

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_TIMEOUT => 90
    ]);

    $response_ai = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($response_ai === false || $http_code !== 200) {
        http_response_code(502);
        echo json_encode(['error' => 'Could not get a valid response from the AI service.']);
        exit;
    }

    $result_array = json_decode($response_ai, true);
    $response_text = $result_array['candidates'][0]['content']['parts'][0]['text'] ?? null;

    if ($response_text === null) {
        http_response_code(500);
        echo json_encode(['error' => 'AI response did not contain the expected format.']);
        exit;
    }

    header('Content-Type: application/json');
    echo $response_text; // Esto SÍ es JSON
    exit;

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal Server Error: ' . $e->getMessage()]);
    exit;
}
?>