<?php
try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $recipient_email = "orozdesign@gmail.com";
        $email_subject = "Ticket De Soporte FlowCMS: " . htmlspecialchars($_POST['subject']);
        $from_email = "no-reply@tunegociocrm.com";

        $name = htmlspecialchars($_POST['name']);
        $email = htmlspecialchars($_POST['email']);
        $subject = htmlspecialchars($_POST['subject']);
        $message_content = htmlspecialchars($_POST['message']);
        $current_page = htmlspecialchars($_POST['current_page']);

        $upload_dir = 'uploads/';
        $attachment_path = null;
        
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] == 0) {
            $file_name = uniqid() . '-' . basename($_FILES['attachment']['name']);
            $target_path = $upload_dir . $file_name;
            
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $target_path)) {
                $attachment_path = $target_path;
            }
        }

        $boundary = "boundary-" . md5(time());
        
        $headers = "From: $from_email\r\n";
        $headers .= "Reply-To: $email\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n";

        $email_body = "--$boundary\r\n";
        $email_body .= "Content-Type: text/html; charset=\"UTF-8\"\r\n";
        $email_body .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $email_body .= "
        <html>
        <body style='font-family: Arial, sans-serif; color: #333;'>
            <h2 style='color: #07162d;'>Nuevo Ticket de Soporte Recibido</h2>
            <p><strong>De:</strong> $name</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Asunto:</strong> $subject</p>
            <p><strong>Enviado desde la página:</strong> $current_page</p>
            <hr>
            <h3 style='color: #07162d;'>Mensaje:</h3>
            <pre style='background-color: #f5f5f5; padding: 15px; border-radius: 5px; white-space: pre-wrap; font-family: Arial, sans-serif;'>$message_content</pre>
        </body>
        </html>
        \r\n";
        
        if ($attachment_path && is_file($attachment_path)) {
            $file_content = file_get_contents($attachment_path);
            $encoded_content = chunk_split(base64_encode($file_content));
            $file_name = basename($attachment_path);
            $file_type = mime_content_type($attachment_path);

            $email_body .= "--$boundary\r\n";
            $email_body .= "Content-Type: $file_type; name=\"$file_name\"\r\n";
            $email_body .= "Content-Disposition: attachment; filename=\"$file_name\"\r\n";
            $email_body .= "Content-Transfer-Encoding: base64\r\n\r\n";
            $email_body .= $encoded_content . "\r\n";
        }
        
        $email_body .= "--$boundary--";

        if (mail($recipient_email, $email_subject, $email_body, $headers, "-f " . $from_email)) {
            if ($attachment_path && is_file($attachment_path)) {
                unlink($attachment_path);
            }
            header("Location: thank-you.php");
            exit();
        } else {
            if ($attachment_path && is_file($attachment_path)) {
                unlink($attachment_path);
            }
            header("Location: error.php");
            exit();
        }

    } else {
        header("Location: /");
        exit();
    }
} catch (Exception $e) {
    error_log("Error critico en el envío del ticket de soporte: " . $e->getMessage());
    if (isset($attachment_path) && is_file($attachment_path)) {
        unlink($attachment_path);
    }
    header("Location: error.php");
    exit();
}
?>