<?php
ob_start();

require_once __DIR__ . '/../core/api.php';
global $pdo;

ini_set('display_errors', 0); 
ini_set('log_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'SOLICITUD NO VÁLIDA'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $blocked_date = filter_var($input['blocked_date'] ?? null, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $reason = filter_var($input['reason'] ?? 'No especificado', FILTER_SANITIZE_FULL_SPECIAL_CHARS); // Añadido campo de razón si existe

    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $blocked_date)) {
        $response['message'] = 'FORMATO DE FECHA INVÁLIDO (DEBE SER AA-MM-DD)';
        ob_end_clean();
        echo json_encode($response);
        exit;
    }

    try {
        $pdo->beginTransaction();

        // 1. Obtener el JSON actual de blocked_dates
        $stmt_get = $pdo->prepare("SELECT blocked_dates FROM schedule_config WHERE user_id = 1 LIMIT 1");
        $stmt_get->execute();
        $current_blocked_dates_row = $stmt_get->fetch(PDO::FETCH_ASSOC);
        $blocked_dates = json_decode($current_blocked_dates_row['blocked_dates'] ?? '[]', true) ?? [];
        
        // 2. Verificar si la fecha ya existe para evitar duplicados lógicos
        $date_exists = false;
        foreach ($blocked_dates as $item) {
            if (($item['date'] ?? '') === $blocked_date) {
                $date_exists = true;
                break;
            }
        }
        
        if (!$date_exists) {
            // 3. Añadir la nueva fecha
            $new_date_entry = ['date' => $blocked_date, 'reason' => $reason];
            $blocked_dates[] = $new_date_entry;
            
            $json_blocked_dates = json_encode($blocked_dates, JSON_UNESCAPED_UNICODE);

            // 4. Actualizar el campo blocked_dates en la base de datos
            $stmt_update = $pdo->prepare("UPDATE schedule_config SET blocked_dates = ? WHERE user_id = 1");
            $stmt_update->execute([$json_blocked_dates]);

            $pdo->commit();
            
            // Devolvemos el array completo para que el cliente pueda actualizar su estado
            $last_index = count($blocked_dates) - 1;
            $response = [
                'status' => 'success', 
                'message' => 'GUARDADO', 
                'id' => $last_index + 1, // Devolvemos el nuevo índice + 1 como ID temporal
                'blocked_date' => $blocked_date
            ];
            
        } else {
            $pdo->rollBack();
            $response = ['status' => 'success', 'message' => 'FECHA YA EXISTENTE'];
        }

    } catch (PDOException $e) {
        if (isset($pdo) && $pdo->inTransaction()) {
            $pdo->rollBack(); 
        }
        error_log("Error en agenda-config-create.php: " . $e->getMessage());
        $response['message'] = 'ERROR DE BASE DE DATOS';
    }
}

ob_end_clean();
echo json_encode($response);
exit;