<?php
require_once dirname(__DIR__) . '/core/api.php';
global $pdo; 

function getBusinessInfoForPDF($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT company_name, logo_url, phone_primary FROM business_info WHERE id = ? LIMIT 1");
        $stmt->execute([1]);
        $generalData = $stmt->fetch(PDO::FETCH_ASSOC);

        $logo_url = $generalData['logo_url'] ?? 'brand/img/LogoCRM.webp';
        if ($logo_url && !filter_var($logo_url, FILTER_VALIDATE_URL)) {
             $cleaned_path = ltrim(str_replace('../', '', $logo_url), '/');
             $logo_url = dirname(__DIR__) . '/' . $cleaned_path;
             if (!file_exists($logo_url)) {
                 error_log("Advertencia PDF: El archivo de logo no se encontró en: " . $logo_url);
                 $logo_url = 'brand/img/LogoCRM.webp';
             }
        }

        return [
            'company_name' => $generalData['company_name'] ?? 'Business Name',
            'logo_url' => $logo_url,
            'phone_primary' => $generalData['phone_primary'] ?? '(425) 555-0000'
        ];

    } catch (PDOException $e) {
        error_log("Error al leer business_info para PDF: " . $e->getMessage());
        return [
            'company_name' => 'Error De Carga CRM',
            'logo_url' => 'brand/img/LogoCRM.webp',
            'phone_primary' => '(425) 555-0000'
        ];
    }
}
?>