<?php ob_start();

// Se incluye la API para asegurar que $pdo esté disponible si se llama externamente.
require_once __DIR__ . '/../core/api.php';

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
error_reporting(E_ALL);

function syncClientServices(PDO $pdo, int $clientId, array $newServiceIds): bool
{
    try {
        $stmtDelete = $pdo->prepare("DELETE FROM client_services WHERE client_id = ?");
        $stmtDelete->execute([$clientId]);

        if (!empty($newServiceIds)) {
            $stmtInsert = $pdo->prepare("INSERT INTO client_services (client_id, service_id) VALUES (?, ?)");
            foreach ($newServiceIds as $serviceId) {
                if (filter_var($serviceId, FILTER_VALIDATE_INT) !== false) {
                    $stmtInsert->execute([$clientId, (int)$serviceId]);
                } else {
                    error_log("ID de servicio inválido detectado durante syncClientServices para cliente ID " . $clientId . ": " . $serviceId);
                }
            }
        }
        return true; 
    } catch (PDOException $e) {
        error_log("Error de PDO al sincronizar servicios para cliente ID " . $clientId . ": " . $e->getMessage());
        return false; 
    } catch (Exception $e) {
        error_log("Error general al sincronizar servicios para cliente ID " . $clientId . ": " . $e->getMessage());
        return false; 
    }
}
// NOTA: Este archivo solo contiene una función y no tiene lógica de ejecución directa POST/GET. 
// La inicialización se añadió para compatibilidad si la función se llama sin el contexto adecuado.
?>