<?php 
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
    error_reporting(E_ALL);

    require_once __DIR__ . '/../core/api.php';
    global $pdo;

    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('ERROR AL PROCESAR DATOS');
    }

    if (!isset($data['id']) || empty($data['id'])) {
        throw new Exception('ID REQUERIDO');
    }

    $transaction_id = filter_var($data['id'], FILTER_VALIDATE_INT);
    if ($transaction_id === false) {
        throw new Exception('ID INVALIDO');
    }

    $sql = "DELETE FROM transactions WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $transaction_id]);

    if ($stmt->rowCount() > 0) {
        $response = ['success' => true, 'message' => 'TRANSACCION ELIMINADA'];
    } else {
        $response = ['success' => false, 'message' => 'NO ENCONTRADO'];
    }

} catch (PDOException $e) {
    error_log("Error PDO en finances-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'ERROR DE BASE DE DATOS'];
} catch (Exception $e) {
    error_log("Error general en finances-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => strtoupper($e->getMessage())];
}

if (ob_get_level() > 0) {
    ob_end_clean();
}
echo json_encode($response);
exit;