<?php
declare(strict_types=1);
ob_start();
header('Content-Type: application/json');
ini_set('display_errors', 0);
error_reporting(E_ALL);

$response = ['success' => false, 'message' => 'ERROR DE AUTENTICACION'];

try {
    require_once '../core/api.php';

    // Leer, Sanitizar y Validar CSRF
    $input = leerInputJSON();
    $data_sanitized = sanitizarDatos($input);
    verificarTokenCSRF($data_sanitized['csrf_token'] ?? '');
    
    // VALIDACIÓN DE DATOS REQUERIDOS
    if (!isset($data_sanitized['id']) || !isset($data_sanitized['status'])) {
        throw new Exception('Faltan datos obligatorios (ID o Estatus)');
    }

    $id = filter_var($data_sanitized['id'], FILTER_VALIDATE_INT);
    if ($id === false) {
        throw new Exception('ID de cotización inválido.');
    }
    
    $status_seguimiento = $data_sanitized['status']; 
    $reason = !empty($data_sanitized['lost_reason']) ? $data_sanitized['lost_reason'] : null; 

    // LÓGICA DE SINCRONIZACIÓN UNIDIRECCIONAL
    $general_status_update_clause = '';
    $message_suffix = '';

    if ($status_seguimiento === 'Cotización Ganada') {
        $general_status_update_clause = "status = 'converted',";
        $message_suffix = ' y estado oficial a CONVERTIDA.';
    } elseif ($status_seguimiento === 'Cotización Perdida' || $status_seguimiento === 'Lead Descartado') {
        $general_status_update_clause = "status = 'rejected',";
        $message_suffix = ' y estado oficial a RECHAZADO.';
    } elseif ($status_seguimiento === 'Cotización Enviada') {
        $general_status_update_clause = "status = 'sent',";
        $message_suffix = ' y estado oficial a ENVIADO.';
    }
    
    $sql = "UPDATE quotes SET 
            status_seguimiento = ?, 
            lost_reason = ?, 
            {$general_status_update_clause} 
            updated_at = NOW() 
            WHERE id = ?";

    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$status_seguimiento, $reason, $id])) {
        if ($stmt->rowCount() > 0) {
            $response = ['success' => true, 'message' => 'Estado de seguimiento actualizado' . $message_suffix];
        } else {
            $response = ['success' => false, 'message' => 'Cotización no encontrada o sin cambios.'];
        }
    } else {
        throw new Exception('Error al ejecutar la consulta SQL.');
    }

} catch (PDOException $e) {
    error_log("Error PDO en quotes-update-status.php: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    if (strpos($e->getMessage(), 'Security') !== false || strpos($e->getMessage(), 'token') !== false) {
         http_response_code(403);
    }
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response);
exit;
?>